# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..types.welcome_wizard_tracking import WelcomeWizardTracking

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawWelcomeWizardClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_welcome_wizard_status(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[WelcomeWizardTracking]:
        """
        Get welcome wizard tracking status for the current workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[WelcomeWizardTracking]
            Welcome wizard tracking status
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/private/welcome-wizard",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WelcomeWizardTracking,
                    parse_obj_as(
                        type_=WelcomeWizardTracking,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def submit_welcome_wizard(
        self,
        *,
        role: typing.Optional[str] = OMIT,
        integrations: typing.Optional[typing.Sequence[str]] = OMIT,
        email: typing.Optional[str] = OMIT,
        join_beta_program: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[None]:
        """
        Submit welcome wizard with user information

        Parameters
        ----------
        role : typing.Optional[str]
            Optional user role

        integrations : typing.Optional[typing.Sequence[str]]
            List of integrations the user selected

        email : typing.Optional[str]
            Optional user email

        join_beta_program : typing.Optional[bool]
            Whether user wants to join beta programs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/private/welcome-wizard",
            method="POST",
            json={
                "role": role,
                "integrations": integrations,
                "email": email,
                "join_beta_program": join_beta_program,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawWelcomeWizardClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_welcome_wizard_status(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[WelcomeWizardTracking]:
        """
        Get welcome wizard tracking status for the current workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[WelcomeWizardTracking]
            Welcome wizard tracking status
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/private/welcome-wizard",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    WelcomeWizardTracking,
                    parse_obj_as(
                        type_=WelcomeWizardTracking,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def submit_welcome_wizard(
        self,
        *,
        role: typing.Optional[str] = OMIT,
        integrations: typing.Optional[typing.Sequence[str]] = OMIT,
        email: typing.Optional[str] = OMIT,
        join_beta_program: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[None]:
        """
        Submit welcome wizard with user information

        Parameters
        ----------
        role : typing.Optional[str]
            Optional user role

        integrations : typing.Optional[typing.Sequence[str]]
            List of integrations the user selected

        email : typing.Optional[str]
            Optional user email

        join_beta_program : typing.Optional[bool]
            Whether user wants to join beta programs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/private/welcome-wizard",
            method="POST",
            json={
                "role": role,
                "integrations": integrations,
                "email": email,
                "join_beta_program": join_beta_program,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
