from yowsup.structs import ProtocolEntity, ProtocolTreeNode
from .iq_groups import GroupsIqProtocolEntity
class ListGroupsIqProtocolEntity(GroupsIqProtocolEntity):
    '''
    <iq id="{{id}}"" type="get" to="g.us" xmlns="w:g">
        <list type="{{participating | owning}}"></list>
    </iq>
    
    result (processed in iq_result_groups_list.py):
    <iq type="result" from="g.us" id="{{IQ_ID}}">
        <group s_t="{{SUBJECT_TIME}}" creation="{{CREATING_TIME}}" owner="{{OWNER_JID}}" id="{{GROUP_ID}}" s_o="{{SUBJECT_OWNER_JID}}" subject="{{SUBJECT}}">
        </group>
        <group s_t="{{SUBJECT_TIME}}" creation="{{CREATING_TIME}}" owner="{{OWNER_JID}}" id="{{GROUP_ID}}" s_o="{{SUBJECT_OWNER_JID}}" subject="{{SUBJECT}}">
        </group>
    </iq>
    '''

    GROUP_TYPE_PARTICIPATING = "participating"
    GROUP_TYPE_OWNING        = "owning"

    GROUPS_TYPES = (GROUP_TYPE_PARTICIPATING, GROUP_TYPE_OWNING)

    def __init__(self, groupsType = GROUP_TYPE_PARTICIPATING):
        super(ListGroupsIqProtocolEntity, self).__init__(to = "g.us", _type = "get")
        self.setProps(groupsType)

    def setProps(self, groupsType):
        assert groupsType in self.__class__.GROUPS_TYPES,\
            "Groups type must be %s, not %s" % (" or ".join(self.__class__.GROUPS_TYPES), groupsType)
        self.groupsType = groupsType

    def toProtocolTreeNode(self):
        node = super(ListGroupsIqProtocolEntity, self).toProtocolTreeNode()
        node.addChild(ProtocolTreeNode("list",{"type": self.groupsType}))
        return node

    @staticmethod
    def fromProtocolTreeNode(node):
        entity = GroupsIqProtocolEntity.fromProtocolTreeNode(node)
        entity.__class__ = ListGroupsIqProtocolEntity
        entity.setProps(node.getChild("list").getAttributeValue("type"))
        return entity