def code():
    return r"""#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#define ALPHABET 26

const char english_freq[] = "ETAOINSHRDLCUMWFGYPBVKJXQZ";

int main() {
    char text[1000], sorted[27] = {0}, map[26];
    int freq[ALPHABET] = {0}, freq_copy[ALPHABET];

    // --- Input ---
    printf("Enter Ciphertext (max 1000 chars):\n");
    fgets(text, sizeof(text), stdin);
    text[strcspn(text, "\n")] = 0; // Remove newline

    // --- Step 1: Calculate & Print Frequency ---
    printf("\n--- Step 1: Calculating Letter Frequencies ---\n");
    printf("\n--- Letter Frequency in Ciphertext ---\n");
    
    for (int i = 0; text[i]; i++) 
        if (isalpha(text[i])) freq[toupper(text[i]) - 'A']++;

    for (int i = 0; i < ALPHABET; i++) {
        printf("%c : %d\n", 'A' + i, freq[i]);
        freq_copy[i] = freq[i]; // Backup for sorting
    }

    // --- Step 2: Sort by Frequency ---
    printf("\n--- Step 2: Sorting Letters by Frequency ---\n");
    
    for (int i = 0; i < ALPHABET; i++) {
        int max_idx = 0;
        for (int j = 0; j < ALPHABET; j++) 
            if (freq_copy[j] > freq_copy[max_idx]) max_idx = j;
        
        sorted[i] = 'A' + max_idx;
        freq_copy[max_idx] = -1; // Mark as used
    }
    printf("Letters sorted by frequency (most frequent first): %s\n", sorted);

    // --- Step 3: Create Mapping ---
    printf("\n--- Step 3: Applying Frequency Analysis Mapping ---\n");
    printf("\n--- Mapping of Ciphertext letters to Guessed Letters ---\n");
    
    for (int i = 0; i < ALPHABET; i++) {
        map[sorted[i] - 'A'] = english_freq[i];
        printf("%c -> %c\n", sorted[i], english_freq[i]);
    }

    // --- Step 4: Decrypt & Print ---
    printf("\n--- Step 4: Resulting Decrypted Text ---\n");
    
    for (int i = 0; text[i]; i++) {
        if (isalpha(text[i])) {
            char decoded = map[toupper(text[i]) - 'A'];
            printf("%c", islower(text[i]) ? tolower(decoded) : decoded);
        } else {
            printf("%c", text[i]);
        }
    }
    printf("\n");

    return 0;
Wkh txlfn eurzq ira mxpsv ryhu wkh odcb grj.

}
"""