# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

import types

__config__ = pulumi.Config('github')


class _ExportableConfig(types.ModuleType):
    @_builtins.property
    def app_auth(self) -> Optional[str]:
        """
        The GitHub App credentials used to connect to GitHub. Conflicts with `token`. Anonymous mode is enabled if both `token` and `app_auth` are not set.
        """
        return __config__.get('appAuth')

    @_builtins.property
    def base_url(self) -> str:
        """
        The GitHub Base API URL
        """
        return __config__.get('baseUrl') or (_utilities.get_env('GITHUB_BASE_URL') or 'https://api.github.com/')

    @_builtins.property
    def insecure(self) -> Optional[bool]:
        """
        Enable `insecure` mode for testing purposes
        """
        return __config__.get_bool('insecure')

    @_builtins.property
    def max_retries(self) -> Optional[int]:
        """
        Number of times to retry a request after receiving an error status codeDefaults to 3
        """
        return __config__.get_int('maxRetries')

    @_builtins.property
    def organization(self) -> Optional[str]:
        """
        The GitHub organization name to manage. Use this field instead of `owner` when managing organization accounts.
        """
        return __config__.get('organization')

    @_builtins.property
    def owner(self) -> Optional[str]:
        """
        The GitHub owner name to manage. Use this field instead of `organization` when managing individual accounts.
        """
        return __config__.get('owner')

    @_builtins.property
    def parallel_requests(self) -> Optional[bool]:
        """
        Allow the provider to make parallel API calls to GitHub. You may want to set it to true when you have a private Github Enterprise without strict rate limits. Although, it is not possible to enable this setting on github.com because we enforce the respect of github.com's best practices to avoid hitting abuse rate limitsDefaults to false if not set
        """
        return __config__.get_bool('parallelRequests')

    @_builtins.property
    def read_delay_ms(self) -> Optional[int]:
        """
        Amount of time in milliseconds to sleep in between non-write requests to GitHub API. Defaults to 0ms if not set.
        """
        return __config__.get_int('readDelayMs')

    @_builtins.property
    def retry_delay_ms(self) -> Optional[int]:
        """
        Amount of time in milliseconds to sleep in between requests to GitHub API after an error response. Defaults to 1000ms or 1s if not set, the max_retries must be set to greater than zero.
        """
        return __config__.get_int('retryDelayMs')

    @_builtins.property
    def retryable_errors(self) -> Optional[str]:
        """
        Allow the provider to retry after receiving an error status code, the max_retries should be set for this to workDefaults to [500, 502, 503, 504]
        """
        return __config__.get('retryableErrors')

    @_builtins.property
    def token(self) -> Optional[str]:
        """
        The OAuth token used to connect to GitHub. Anonymous mode is enabled if both `token` and `app_auth` are not set.
        """
        return __config__.get('token') or _utilities.get_env('GITHUB_TOKEN')

    @_builtins.property
    def write_delay_ms(self) -> Optional[int]:
        """
        Amount of time in milliseconds to sleep in between writes to GitHub API. Defaults to 1000ms or 1s if not set.
        """
        return __config__.get_int('writeDelayMs')

