# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetTeamResult',
    'AwaitableGetTeamResult',
    'get_team',
    'get_team_output',
]

@pulumi.output_type
class GetTeamResult:
    """
    A collection of values returned by getTeam.
    """
    def __init__(__self__, description=None, id=None, members=None, membership_type=None, name=None, node_id=None, permission=None, privacy=None, repositories=None, repositories_detaileds=None, results_per_page=None, slug=None, summary_only=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if members and not isinstance(members, list):
            raise TypeError("Expected argument 'members' to be a list")
        pulumi.set(__self__, "members", members)
        if membership_type and not isinstance(membership_type, str):
            raise TypeError("Expected argument 'membership_type' to be a str")
        pulumi.set(__self__, "membership_type", membership_type)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if node_id and not isinstance(node_id, str):
            raise TypeError("Expected argument 'node_id' to be a str")
        pulumi.set(__self__, "node_id", node_id)
        if permission and not isinstance(permission, str):
            raise TypeError("Expected argument 'permission' to be a str")
        pulumi.set(__self__, "permission", permission)
        if privacy and not isinstance(privacy, str):
            raise TypeError("Expected argument 'privacy' to be a str")
        pulumi.set(__self__, "privacy", privacy)
        if repositories and not isinstance(repositories, list):
            raise TypeError("Expected argument 'repositories' to be a list")
        pulumi.set(__self__, "repositories", repositories)
        if repositories_detaileds and not isinstance(repositories_detaileds, list):
            raise TypeError("Expected argument 'repositories_detaileds' to be a list")
        pulumi.set(__self__, "repositories_detaileds", repositories_detaileds)
        if results_per_page and not isinstance(results_per_page, int):
            raise TypeError("Expected argument 'results_per_page' to be a int")
        pulumi.set(__self__, "results_per_page", results_per_page)
        if slug and not isinstance(slug, str):
            raise TypeError("Expected argument 'slug' to be a str")
        pulumi.set(__self__, "slug", slug)
        if summary_only and not isinstance(summary_only, bool):
            raise TypeError("Expected argument 'summary_only' to be a bool")
        pulumi.set(__self__, "summary_only", summary_only)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        the team's description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def members(self) -> Sequence[_builtins.str]:
        """
        List of team members (list of GitHub usernames). Not returned if `summary_only = true`
        """
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter(name="membershipType")
    def membership_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "membership_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        the team's full name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> _builtins.str:
        """
        the Node ID of the team.
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter
    def permission(self) -> _builtins.str:
        """
        the team's permission level.
        """
        return pulumi.get(self, "permission")

    @_builtins.property
    @pulumi.getter
    def privacy(self) -> _builtins.str:
        """
        the team's privacy type.
        """
        return pulumi.get(self, "privacy")

    @_builtins.property
    @pulumi.getter
    def repositories(self) -> Sequence[_builtins.str]:
        """
        List of team repositories (list of repo names). Not returned if `summary_only = true`
        """
        return pulumi.get(self, "repositories")

    @_builtins.property
    @pulumi.getter(name="repositoriesDetaileds")
    def repositories_detaileds(self) -> Sequence['outputs.GetTeamRepositoriesDetailedResult']:
        """
        List of team repositories (list of `repo_id` and `role_name`). Not returned if `summary_only = true`
        """
        return pulumi.get(self, "repositories_detaileds")

    @_builtins.property
    @pulumi.getter(name="resultsPerPage")
    def results_per_page(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "results_per_page")

    @_builtins.property
    @pulumi.getter
    def slug(self) -> _builtins.str:
        return pulumi.get(self, "slug")

    @_builtins.property
    @pulumi.getter(name="summaryOnly")
    def summary_only(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "summary_only")


class AwaitableGetTeamResult(GetTeamResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTeamResult(
            description=self.description,
            id=self.id,
            members=self.members,
            membership_type=self.membership_type,
            name=self.name,
            node_id=self.node_id,
            permission=self.permission,
            privacy=self.privacy,
            repositories=self.repositories,
            repositories_detaileds=self.repositories_detaileds,
            results_per_page=self.results_per_page,
            slug=self.slug,
            summary_only=self.summary_only)


def get_team(membership_type: Optional[_builtins.str] = None,
             results_per_page: Optional[_builtins.int] = None,
             slug: Optional[_builtins.str] = None,
             summary_only: Optional[_builtins.bool] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTeamResult:
    """
    Use this data source to retrieve information about a GitHub team.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example = github.get_team(slug="example")
    ```


    :param _builtins.str membership_type: Type of membership to be requested to fill the list of members. Can be either "all" or "immediate". Default: "all"
    :param _builtins.int results_per_page: Set the number of results per graphql query. Reducing this number can alleviate timeout errors. Accepts a value between 0 - 100. Defaults to `100`.
    :param _builtins.str slug: The team slug.
    :param _builtins.bool summary_only: Exclude the members and repositories of the team from the returned result. Defaults to `false`.
    """
    __args__ = dict()
    __args__['membershipType'] = membership_type
    __args__['resultsPerPage'] = results_per_page
    __args__['slug'] = slug
    __args__['summaryOnly'] = summary_only
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('github:index/getTeam:getTeam', __args__, opts=opts, typ=GetTeamResult).value

    return AwaitableGetTeamResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        members=pulumi.get(__ret__, 'members'),
        membership_type=pulumi.get(__ret__, 'membership_type'),
        name=pulumi.get(__ret__, 'name'),
        node_id=pulumi.get(__ret__, 'node_id'),
        permission=pulumi.get(__ret__, 'permission'),
        privacy=pulumi.get(__ret__, 'privacy'),
        repositories=pulumi.get(__ret__, 'repositories'),
        repositories_detaileds=pulumi.get(__ret__, 'repositories_detaileds'),
        results_per_page=pulumi.get(__ret__, 'results_per_page'),
        slug=pulumi.get(__ret__, 'slug'),
        summary_only=pulumi.get(__ret__, 'summary_only'))
def get_team_output(membership_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    results_per_page: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                    slug: Optional[pulumi.Input[_builtins.str]] = None,
                    summary_only: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTeamResult]:
    """
    Use this data source to retrieve information about a GitHub team.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    example = github.get_team(slug="example")
    ```


    :param _builtins.str membership_type: Type of membership to be requested to fill the list of members. Can be either "all" or "immediate". Default: "all"
    :param _builtins.int results_per_page: Set the number of results per graphql query. Reducing this number can alleviate timeout errors. Accepts a value between 0 - 100. Defaults to `100`.
    :param _builtins.str slug: The team slug.
    :param _builtins.bool summary_only: Exclude the members and repositories of the team from the returned result. Defaults to `false`.
    """
    __args__ = dict()
    __args__['membershipType'] = membership_type
    __args__['resultsPerPage'] = results_per_page
    __args__['slug'] = slug
    __args__['summaryOnly'] = summary_only
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('github:index/getTeam:getTeam', __args__, opts=opts, typ=GetTeamResult)
    return __ret__.apply(lambda __response__: GetTeamResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        members=pulumi.get(__response__, 'members'),
        membership_type=pulumi.get(__response__, 'membership_type'),
        name=pulumi.get(__response__, 'name'),
        node_id=pulumi.get(__response__, 'node_id'),
        permission=pulumi.get(__response__, 'permission'),
        privacy=pulumi.get(__response__, 'privacy'),
        repositories=pulumi.get(__response__, 'repositories'),
        repositories_detaileds=pulumi.get(__response__, 'repositories_detaileds'),
        results_per_page=pulumi.get(__response__, 'results_per_page'),
        slug=pulumi.get(__response__, 'slug'),
        summary_only=pulumi.get(__response__, 'summary_only')))
