import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AntiddosV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1.html#app_type_id AntiddosV1#app_type_id}.
     *
     * @stability stable
     */
    readonly appTypeId: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1.html#cleaning_access_pos_id AntiddosV1#cleaning_access_pos_id}.
     *
     * @stability stable
     */
    readonly cleaningAccessPosId: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1.html#enable_l7 AntiddosV1#enable_l7}.
     *
     * @stability stable
     */
    readonly enableL7: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1.html#floating_ip_id AntiddosV1#floating_ip_id}.
     *
     * @stability stable
     */
    readonly floatingIpId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1.html#http_request_pos_id AntiddosV1#http_request_pos_id}.
     *
     * @stability stable
     */
    readonly httpRequestPosId: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1.html#region AntiddosV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1.html#traffic_pos_id AntiddosV1#traffic_pos_id}.
     *
     * @stability stable
     */
    readonly trafficPosId: number;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1.html#timeouts AntiddosV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AntiddosV1Timeouts;
}
/**
 * @stability stable
 */
export interface AntiddosV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1.html#create AntiddosV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1.html#delete AntiddosV1#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1.html#update AntiddosV1#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class AntiddosV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1.html opentelekomcloud_antiddos_v1}.
 *
 * @stability stable
 */
export declare class AntiddosV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/antiddos_v1.html opentelekomcloud_antiddos_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AntiddosV1Config);
    private _appTypeId?;
    /**
     * @stability stable
     */
    get appTypeId(): number;
    /**
     * @stability stable
     */
    set appTypeId(value: number);
    /**
     * @stability stable
     */
    get appTypeIdInput(): number | undefined;
    private _cleaningAccessPosId?;
    /**
     * @stability stable
     */
    get cleaningAccessPosId(): number;
    /**
     * @stability stable
     */
    set cleaningAccessPosId(value: number);
    /**
     * @stability stable
     */
    get cleaningAccessPosIdInput(): number | undefined;
    private _enableL7?;
    /**
     * @stability stable
     */
    get enableL7(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableL7(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enableL7Input(): boolean | cdktf.IResolvable | undefined;
    private _floatingIpId?;
    /**
     * @stability stable
     */
    get floatingIpId(): string;
    /**
     * @stability stable
     */
    set floatingIpId(value: string);
    /**
     * @stability stable
     */
    get floatingIpIdInput(): string | undefined;
    private _httpRequestPosId?;
    /**
     * @stability stable
     */
    get httpRequestPosId(): number;
    /**
     * @stability stable
     */
    set httpRequestPosId(value: number);
    /**
     * @stability stable
     */
    get httpRequestPosIdInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _trafficPosId?;
    /**
     * @stability stable
     */
    get trafficPosId(): number;
    /**
     * @stability stable
     */
    set trafficPosId(value: number);
    /**
     * @stability stable
     */
    get trafficPosIdInput(): number | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): AntiddosV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AntiddosV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AntiddosV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
