import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AsConfigurationV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#region AsConfigurationV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#scaling_configuration_name AsConfigurationV1#scaling_configuration_name}.
     *
     * @stability stable
     */
    readonly scalingConfigurationName: string;
    /**
     * instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#instance_config AsConfigurationV1#instance_config}
     *
     * @stability stable
     */
    readonly instanceConfig: AsConfigurationV1InstanceConfig;
}
/**
 * @stability stable
 */
export interface AsConfigurationV1InstanceConfigDisk {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#disk_type AsConfigurationV1#disk_type}.
     *
     * @stability stable
     */
    readonly diskType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#kms_id AsConfigurationV1#kms_id}.
     *
     * @stability stable
     */
    readonly kmsId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#size AsConfigurationV1#size}.
     *
     * @stability stable
     */
    readonly size: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#volume_type AsConfigurationV1#volume_type}.
     *
     * @stability stable
     */
    readonly volumeType: string;
}
/**
 * @stability stable
 */
export interface AsConfigurationV1InstanceConfigPersonality {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#content AsConfigurationV1#content}.
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#path AsConfigurationV1#path}.
     *
     * @stability stable
     */
    readonly path: string;
}
/**
 * @stability stable
 */
export interface AsConfigurationV1InstanceConfigPublicIpEipBandwidth {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#charging_mode AsConfigurationV1#charging_mode}.
     *
     * @stability stable
     */
    readonly chargingMode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#share_type AsConfigurationV1#share_type}.
     *
     * @stability stable
     */
    readonly shareType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#size AsConfigurationV1#size}.
     *
     * @stability stable
     */
    readonly size: number;
}
/**
 * @stability stable
 */
export declare class AsConfigurationV1InstanceConfigPublicIpEipBandwidthOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _chargingMode?;
    /**
     * @stability stable
     */
    get chargingMode(): string;
    /**
     * @stability stable
     */
    set chargingMode(value: string);
    /**
     * @stability stable
     */
    get chargingModeInput(): string | undefined;
    private _shareType?;
    /**
     * @stability stable
     */
    get shareType(): string;
    /**
     * @stability stable
     */
    set shareType(value: string);
    /**
     * @stability stable
     */
    get shareTypeInput(): string | undefined;
    private _size?;
    /**
     * @stability stable
     */
    get size(): number;
    /**
     * @stability stable
     */
    set size(value: number);
    /**
     * @stability stable
     */
    get sizeInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface AsConfigurationV1InstanceConfigPublicIpEip {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#ip_type AsConfigurationV1#ip_type}.
     *
     * @stability stable
     */
    readonly ipType: string;
    /**
     * bandwidth block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#bandwidth AsConfigurationV1#bandwidth}
     *
     * @stability stable
     */
    readonly bandwidth: AsConfigurationV1InstanceConfigPublicIpEipBandwidth;
}
/**
 * @stability stable
 */
export declare class AsConfigurationV1InstanceConfigPublicIpEipOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _ipType?;
    /**
     * @stability stable
     */
    get ipType(): string;
    /**
     * @stability stable
     */
    set ipType(value: string);
    /**
     * @stability stable
     */
    get ipTypeInput(): string | undefined;
    private _bandwidth?;
    private __bandwidthOutput;
    /**
     * @stability stable
     */
    get bandwidth(): AsConfigurationV1InstanceConfigPublicIpEipBandwidthOutputReference;
    /**
     * @stability stable
     */
    putBandwidth(value: AsConfigurationV1InstanceConfigPublicIpEipBandwidth): void;
    /**
     * @stability stable
     */
    get bandwidthInput(): AsConfigurationV1InstanceConfigPublicIpEipBandwidth | undefined;
}
/**
 * @stability stable
 */
export interface AsConfigurationV1InstanceConfigPublicIp {
    /**
     * eip block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#eip AsConfigurationV1#eip}
     *
     * @stability stable
     */
    readonly eip: AsConfigurationV1InstanceConfigPublicIpEip;
}
/**
 * @stability stable
 */
export declare class AsConfigurationV1InstanceConfigPublicIpOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _eip?;
    private __eipOutput;
    /**
     * @stability stable
     */
    get eip(): AsConfigurationV1InstanceConfigPublicIpEipOutputReference;
    /**
     * @stability stable
     */
    putEip(value: AsConfigurationV1InstanceConfigPublicIpEip): void;
    /**
     * @stability stable
     */
    get eipInput(): AsConfigurationV1InstanceConfigPublicIpEip | undefined;
}
/**
 * @stability stable
 */
export interface AsConfigurationV1InstanceConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#flavor AsConfigurationV1#flavor}.
     *
     * @stability stable
     */
    readonly flavor?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#image AsConfigurationV1#image}.
     *
     * @stability stable
     */
    readonly image?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#instance_id AsConfigurationV1#instance_id}.
     *
     * @stability stable
     */
    readonly instanceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#key_name AsConfigurationV1#key_name}.
     *
     * @stability stable
     */
    readonly keyName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#metadata AsConfigurationV1#metadata}.
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#security_groups AsConfigurationV1#security_groups}.
     *
     * @stability stable
     */
    readonly securityGroups?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#user_data AsConfigurationV1#user_data}.
     *
     * @stability stable
     */
    readonly userData?: string;
    /**
     * disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#disk AsConfigurationV1#disk}
     *
     * @stability stable
     */
    readonly disk?: AsConfigurationV1InstanceConfigDisk[];
    /**
     * personality block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#personality AsConfigurationV1#personality}
     *
     * @stability stable
     */
    readonly personality?: AsConfigurationV1InstanceConfigPersonality[];
    /**
     * public_ip block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html#public_ip AsConfigurationV1#public_ip}
     *
     * @stability stable
     */
    readonly publicIp?: AsConfigurationV1InstanceConfigPublicIp;
}
/**
 * @stability stable
 */
export declare class AsConfigurationV1InstanceConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _flavor?;
    /**
     * @stability stable
     */
    get flavor(): string | undefined;
    /**
     * @stability stable
     */
    set flavor(value: string | undefined);
    /**
     * @stability stable
     */
    resetFlavor(): void;
    /**
     * @stability stable
     */
    get flavorInput(): string | undefined;
    private _image?;
    /**
     * @stability stable
     */
    get image(): string | undefined;
    /**
     * @stability stable
     */
    set image(value: string | undefined);
    /**
     * @stability stable
     */
    resetImage(): void;
    /**
     * @stability stable
     */
    get imageInput(): string | undefined;
    private _instanceId?;
    /**
     * @stability stable
     */
    get instanceId(): string | undefined;
    /**
     * @stability stable
     */
    set instanceId(value: string | undefined);
    /**
     * @stability stable
     */
    resetInstanceId(): void;
    /**
     * @stability stable
     */
    get instanceIdInput(): string | undefined;
    private _keyName?;
    /**
     * @stability stable
     */
    get keyName(): string;
    /**
     * @stability stable
     */
    set keyName(value: string);
    /**
     * @stability stable
     */
    get keyNameInput(): string | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _securityGroups?;
    /**
     * @stability stable
     */
    get securityGroups(): string[] | undefined;
    /**
     * @stability stable
     */
    set securityGroups(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetSecurityGroups(): void;
    /**
     * @stability stable
     */
    get securityGroupsInput(): string[] | undefined;
    private _userData?;
    /**
     * @stability stable
     */
    get userData(): string | undefined;
    /**
     * @stability stable
     */
    set userData(value: string | undefined);
    /**
     * @stability stable
     */
    resetUserData(): void;
    /**
     * @stability stable
     */
    get userDataInput(): string | undefined;
    private _disk?;
    /**
     * @stability stable
     */
    get disk(): AsConfigurationV1InstanceConfigDisk[] | undefined;
    /**
     * @stability stable
     */
    set disk(value: AsConfigurationV1InstanceConfigDisk[] | undefined);
    /**
     * @stability stable
     */
    resetDisk(): void;
    /**
     * @stability stable
     */
    get diskInput(): AsConfigurationV1InstanceConfigDisk[] | undefined;
    private _personality?;
    /**
     * @stability stable
     */
    get personality(): AsConfigurationV1InstanceConfigPersonality[] | undefined;
    /**
     * @stability stable
     */
    set personality(value: AsConfigurationV1InstanceConfigPersonality[] | undefined);
    /**
     * @stability stable
     */
    resetPersonality(): void;
    /**
     * @stability stable
     */
    get personalityInput(): AsConfigurationV1InstanceConfigPersonality[] | undefined;
    private _publicIp?;
    private __publicIpOutput;
    /**
     * @stability stable
     */
    get publicIp(): AsConfigurationV1InstanceConfigPublicIpOutputReference;
    /**
     * @stability stable
     */
    putPublicIp(value: AsConfigurationV1InstanceConfigPublicIp | undefined): void;
    /**
     * @stability stable
     */
    resetPublicIp(): void;
    /**
     * @stability stable
     */
    get publicIpInput(): AsConfigurationV1InstanceConfigPublicIp | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html opentelekomcloud_as_configuration_v1}.
 *
 * @stability stable
 */
export declare class AsConfigurationV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_configuration_v1.html opentelekomcloud_as_configuration_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AsConfigurationV1Config);
    /**
     * @stability stable
     */
    get id(): string;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _scalingConfigurationName?;
    /**
     * @stability stable
     */
    get scalingConfigurationName(): string;
    /**
     * @stability stable
     */
    set scalingConfigurationName(value: string);
    /**
     * @stability stable
     */
    get scalingConfigurationNameInput(): string | undefined;
    private _instanceConfig?;
    private __instanceConfigOutput;
    /**
     * @stability stable
     */
    get instanceConfig(): AsConfigurationV1InstanceConfigOutputReference;
    /**
     * @stability stable
     */
    putInstanceConfig(value: AsConfigurationV1InstanceConfig): void;
    /**
     * @stability stable
     */
    get instanceConfigInput(): AsConfigurationV1InstanceConfig | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
