import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AsGroupV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#available_zones AsGroupV1#available_zones}.
     *
     * @stability stable
     */
    readonly availableZones?: string[];
    /**
     * The cooling duration, in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#cool_down_time AsGroupV1#cool_down_time}
     *
     * @stability stable
     */
    readonly coolDownTime?: number;
    /**
     * Whether to delete instances when they are removed from the AS group.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#delete_instances AsGroupV1#delete_instances}
     *
     * @stability stable
     */
    readonly deleteInstances?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#delete_publicip AsGroupV1#delete_publicip}.
     *
     * @stability stable
     */
    readonly deletePublicip?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#desire_instance_number AsGroupV1#desire_instance_number}.
     *
     * @stability stable
     */
    readonly desireInstanceNumber?: number;
    /**
     * The grace period for instance health check, in seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#health_periodic_audit_grace_period AsGroupV1#health_periodic_audit_grace_period}
     *
     * @stability stable
     */
    readonly healthPeriodicAuditGracePeriod?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#health_periodic_audit_method AsGroupV1#health_periodic_audit_method}.
     *
     * @stability stable
     */
    readonly healthPeriodicAuditMethod?: string;
    /**
     * The health check period for instances, in minutes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#health_periodic_audit_time AsGroupV1#health_periodic_audit_time}
     *
     * @stability stable
     */
    readonly healthPeriodicAuditTime?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#instance_terminate_policy AsGroupV1#instance_terminate_policy}.
     *
     * @stability stable
     */
    readonly instanceTerminatePolicy?: string;
    /**
     * The system supports the binding of up to six classic LB listeners, the IDs of which are separated using a comma.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#lb_listener_id AsGroupV1#lb_listener_id}
     *
     * @stability stable
     */
    readonly lbListenerId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#max_instance_number AsGroupV1#max_instance_number}.
     *
     * @stability stable
     */
    readonly maxInstanceNumber?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#min_instance_number AsGroupV1#min_instance_number}.
     *
     * @stability stable
     */
    readonly minInstanceNumber?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#notifications AsGroupV1#notifications}.
     *
     * @stability stable
     */
    readonly notifications?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#region AsGroupV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#scaling_configuration_id AsGroupV1#scaling_configuration_id}.
     *
     * @stability stable
     */
    readonly scalingConfigurationId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#scaling_group_name AsGroupV1#scaling_group_name}.
     *
     * @stability stable
     */
    readonly scalingGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#tags AsGroupV1#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#vpc_id AsGroupV1#vpc_id}.
     *
     * @stability stable
     */
    readonly vpcId: string;
    /**
     * lbaas_listeners block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#lbaas_listeners AsGroupV1#lbaas_listeners}
     *
     * @stability stable
     */
    readonly lbaasListeners?: AsGroupV1LbaasListeners[];
    /**
     * networks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#networks AsGroupV1#networks}
     *
     * @stability stable
     */
    readonly networks: AsGroupV1Networks[];
    /**
     * security_groups block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#security_groups AsGroupV1#security_groups}
     *
     * @stability stable
     */
    readonly securityGroups?: AsGroupV1SecurityGroups;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#timeouts AsGroupV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AsGroupV1Timeouts;
}
/**
 * @stability stable
 */
export interface AsGroupV1LbaasListeners {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#pool_id AsGroupV1#pool_id}.
     *
     * @stability stable
     */
    readonly poolId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#protocol_port AsGroupV1#protocol_port}.
     *
     * @stability stable
     */
    readonly protocolPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#weight AsGroupV1#weight}.
     *
     * @stability stable
     */
    readonly weight?: number;
}
/**
 * @stability stable
 */
export interface AsGroupV1Networks {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#id AsGroupV1#id}.
     *
     * @stability stable
     */
    readonly id: string;
}
/**
 * @stability stable
 */
export interface AsGroupV1SecurityGroups {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#id AsGroupV1#id}.
     *
     * @stability stable
     */
    readonly id: string;
}
/**
 * @stability stable
 */
export declare class AsGroupV1SecurityGroupsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AsGroupV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#create AsGroupV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html#delete AsGroupV1#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class AsGroupV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html opentelekomcloud_as_group_v1}.
 *
 * @stability stable
 */
export declare class AsGroupV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_group_v1.html opentelekomcloud_as_group_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AsGroupV1Config);
    private _availableZones?;
    /**
     * @stability stable
     */
    get availableZones(): string[] | undefined;
    /**
     * @stability stable
     */
    set availableZones(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetAvailableZones(): void;
    /**
     * @stability stable
     */
    get availableZonesInput(): string[] | undefined;
    private _coolDownTime?;
    /**
     * @stability stable
     */
    get coolDownTime(): number | undefined;
    /**
     * @stability stable
     */
    set coolDownTime(value: number | undefined);
    /**
     * @stability stable
     */
    resetCoolDownTime(): void;
    /**
     * @stability stable
     */
    get coolDownTimeInput(): number | undefined;
    /**
     * @stability stable
     */
    get currentInstanceNumber(): number;
    private _deleteInstances?;
    /**
     * @stability stable
     */
    get deleteInstances(): string | undefined;
    /**
     * @stability stable
     */
    set deleteInstances(value: string | undefined);
    /**
     * @stability stable
     */
    resetDeleteInstances(): void;
    /**
     * @stability stable
     */
    get deleteInstancesInput(): string | undefined;
    private _deletePublicip?;
    /**
     * @stability stable
     */
    get deletePublicip(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set deletePublicip(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDeletePublicip(): void;
    /**
     * @stability stable
     */
    get deletePublicipInput(): boolean | cdktf.IResolvable | undefined;
    private _desireInstanceNumber?;
    /**
     * @stability stable
     */
    get desireInstanceNumber(): number | undefined;
    /**
     * @stability stable
     */
    set desireInstanceNumber(value: number | undefined);
    /**
     * @stability stable
     */
    resetDesireInstanceNumber(): void;
    /**
     * @stability stable
     */
    get desireInstanceNumberInput(): number | undefined;
    private _healthPeriodicAuditGracePeriod?;
    /**
     * @stability stable
     */
    get healthPeriodicAuditGracePeriod(): number | undefined;
    /**
     * @stability stable
     */
    set healthPeriodicAuditGracePeriod(value: number | undefined);
    /**
     * @stability stable
     */
    resetHealthPeriodicAuditGracePeriod(): void;
    /**
     * @stability stable
     */
    get healthPeriodicAuditGracePeriodInput(): number | undefined;
    private _healthPeriodicAuditMethod?;
    /**
     * @stability stable
     */
    get healthPeriodicAuditMethod(): string | undefined;
    /**
     * @stability stable
     */
    set healthPeriodicAuditMethod(value: string | undefined);
    /**
     * @stability stable
     */
    resetHealthPeriodicAuditMethod(): void;
    /**
     * @stability stable
     */
    get healthPeriodicAuditMethodInput(): string | undefined;
    private _healthPeriodicAuditTime?;
    /**
     * @stability stable
     */
    get healthPeriodicAuditTime(): number | undefined;
    /**
     * @stability stable
     */
    set healthPeriodicAuditTime(value: number | undefined);
    /**
     * @stability stable
     */
    resetHealthPeriodicAuditTime(): void;
    /**
     * @stability stable
     */
    get healthPeriodicAuditTimeInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _instanceTerminatePolicy?;
    /**
     * @stability stable
     */
    get instanceTerminatePolicy(): string | undefined;
    /**
     * @stability stable
     */
    set instanceTerminatePolicy(value: string | undefined);
    /**
     * @stability stable
     */
    resetInstanceTerminatePolicy(): void;
    /**
     * @stability stable
     */
    get instanceTerminatePolicyInput(): string | undefined;
    /**
     * @stability stable
     */
    get instances(): string[];
    private _lbListenerId?;
    /**
     * @stability stable
     */
    get lbListenerId(): string | undefined;
    /**
     * @stability stable
     */
    set lbListenerId(value: string | undefined);
    /**
     * @stability stable
     */
    resetLbListenerId(): void;
    /**
     * @stability stable
     */
    get lbListenerIdInput(): string | undefined;
    private _maxInstanceNumber?;
    /**
     * @stability stable
     */
    get maxInstanceNumber(): number | undefined;
    /**
     * @stability stable
     */
    set maxInstanceNumber(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxInstanceNumber(): void;
    /**
     * @stability stable
     */
    get maxInstanceNumberInput(): number | undefined;
    private _minInstanceNumber?;
    /**
     * @stability stable
     */
    get minInstanceNumber(): number | undefined;
    /**
     * @stability stable
     */
    set minInstanceNumber(value: number | undefined);
    /**
     * @stability stable
     */
    resetMinInstanceNumber(): void;
    /**
     * @stability stable
     */
    get minInstanceNumberInput(): number | undefined;
    private _notifications?;
    /**
     * @stability stable
     */
    get notifications(): string[] | undefined;
    /**
     * @stability stable
     */
    set notifications(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetNotifications(): void;
    /**
     * @stability stable
     */
    get notificationsInput(): string[] | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _scalingConfigurationId?;
    /**
     * @stability stable
     */
    get scalingConfigurationId(): string | undefined;
    /**
     * @stability stable
     */
    set scalingConfigurationId(value: string | undefined);
    /**
     * @stability stable
     */
    resetScalingConfigurationId(): void;
    /**
     * @stability stable
     */
    get scalingConfigurationIdInput(): string | undefined;
    private _scalingGroupName?;
    /**
     * @stability stable
     */
    get scalingGroupName(): string;
    /**
     * @stability stable
     */
    set scalingGroupName(value: string);
    /**
     * @stability stable
     */
    get scalingGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _vpcId?;
    /**
     * @stability stable
     */
    get vpcId(): string;
    /**
     * @stability stable
     */
    set vpcId(value: string);
    /**
     * @stability stable
     */
    get vpcIdInput(): string | undefined;
    private _lbaasListeners?;
    /**
     * @stability stable
     */
    get lbaasListeners(): AsGroupV1LbaasListeners[] | undefined;
    /**
     * @stability stable
     */
    set lbaasListeners(value: AsGroupV1LbaasListeners[] | undefined);
    /**
     * @stability stable
     */
    resetLbaasListeners(): void;
    /**
     * @stability stable
     */
    get lbaasListenersInput(): AsGroupV1LbaasListeners[] | undefined;
    private _networks?;
    /**
     * @stability stable
     */
    get networks(): AsGroupV1Networks[];
    /**
     * @stability stable
     */
    set networks(value: AsGroupV1Networks[]);
    /**
     * @stability stable
     */
    get networksInput(): AsGroupV1Networks[] | undefined;
    private _securityGroups?;
    private __securityGroupsOutput;
    /**
     * @stability stable
     */
    get securityGroups(): AsGroupV1SecurityGroupsOutputReference;
    /**
     * @stability stable
     */
    putSecurityGroups(value: AsGroupV1SecurityGroups | undefined): void;
    /**
     * @stability stable
     */
    resetSecurityGroups(): void;
    /**
     * @stability stable
     */
    get securityGroupsInput(): AsGroupV1SecurityGroups | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): AsGroupV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AsGroupV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AsGroupV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
