import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AsPolicyV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1.html#alarm_id AsPolicyV1#alarm_id}.
     *
     * @stability stable
     */
    readonly alarmId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1.html#cool_down_time AsPolicyV1#cool_down_time}.
     *
     * @stability stable
     */
    readonly coolDownTime?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1.html#region AsPolicyV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1.html#scaling_group_id AsPolicyV1#scaling_group_id}.
     *
     * @stability stable
     */
    readonly scalingGroupId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1.html#scaling_policy_name AsPolicyV1#scaling_policy_name}.
     *
     * @stability stable
     */
    readonly scalingPolicyName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1.html#scaling_policy_type AsPolicyV1#scaling_policy_type}.
     *
     * @stability stable
     */
    readonly scalingPolicyType: string;
    /**
     * scaling_policy_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1.html#scaling_policy_action AsPolicyV1#scaling_policy_action}
     *
     * @stability stable
     */
    readonly scalingPolicyAction?: AsPolicyV1ScalingPolicyAction;
    /**
     * scheduled_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1.html#scheduled_policy AsPolicyV1#scheduled_policy}
     *
     * @stability stable
     */
    readonly scheduledPolicy?: AsPolicyV1ScheduledPolicy;
}
/**
 * @stability stable
 */
export interface AsPolicyV1ScalingPolicyAction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1.html#instance_number AsPolicyV1#instance_number}.
     *
     * @stability stable
     */
    readonly instanceNumber?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1.html#operation AsPolicyV1#operation}.
     *
     * @stability stable
     */
    readonly operation?: string;
}
/**
 * @stability stable
 */
export declare class AsPolicyV1ScalingPolicyActionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _instanceNumber?;
    /**
     * @stability stable
     */
    get instanceNumber(): number | undefined;
    /**
     * @stability stable
     */
    set instanceNumber(value: number | undefined);
    /**
     * @stability stable
     */
    resetInstanceNumber(): void;
    /**
     * @stability stable
     */
    get instanceNumberInput(): number | undefined;
    private _operation?;
    /**
     * @stability stable
     */
    get operation(): string | undefined;
    /**
     * @stability stable
     */
    set operation(value: string | undefined);
    /**
     * @stability stable
     */
    resetOperation(): void;
    /**
     * @stability stable
     */
    get operationInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AsPolicyV1ScheduledPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1.html#end_time AsPolicyV1#end_time}.
     *
     * @stability stable
     */
    readonly endTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1.html#launch_time AsPolicyV1#launch_time}.
     *
     * @stability stable
     */
    readonly launchTime: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1.html#recurrence_type AsPolicyV1#recurrence_type}.
     *
     * @stability stable
     */
    readonly recurrenceType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1.html#recurrence_value AsPolicyV1#recurrence_value}.
     *
     * @stability stable
     */
    readonly recurrenceValue?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1.html#start_time AsPolicyV1#start_time}.
     *
     * @stability stable
     */
    readonly startTime?: string;
}
/**
 * @stability stable
 */
export declare class AsPolicyV1ScheduledPolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _endTime?;
    /**
     * @stability stable
     */
    get endTime(): string | undefined;
    /**
     * @stability stable
     */
    set endTime(value: string | undefined);
    /**
     * @stability stable
     */
    resetEndTime(): void;
    /**
     * @stability stable
     */
    get endTimeInput(): string | undefined;
    private _launchTime?;
    /**
     * @stability stable
     */
    get launchTime(): string;
    /**
     * @stability stable
     */
    set launchTime(value: string);
    /**
     * @stability stable
     */
    get launchTimeInput(): string | undefined;
    private _recurrenceType?;
    /**
     * @stability stable
     */
    get recurrenceType(): string | undefined;
    /**
     * @stability stable
     */
    set recurrenceType(value: string | undefined);
    /**
     * @stability stable
     */
    resetRecurrenceType(): void;
    /**
     * @stability stable
     */
    get recurrenceTypeInput(): string | undefined;
    private _recurrenceValue?;
    /**
     * @stability stable
     */
    get recurrenceValue(): string | undefined;
    /**
     * @stability stable
     */
    set recurrenceValue(value: string | undefined);
    /**
     * @stability stable
     */
    resetRecurrenceValue(): void;
    /**
     * @stability stable
     */
    get recurrenceValueInput(): string | undefined;
    private _startTime?;
    /**
     * @stability stable
     */
    get startTime(): string | undefined;
    /**
     * @stability stable
     */
    set startTime(value: string | undefined);
    /**
     * @stability stable
     */
    resetStartTime(): void;
    /**
     * @stability stable
     */
    get startTimeInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1.html opentelekomcloud_as_policy_v1}.
 *
 * @stability stable
 */
export declare class AsPolicyV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v1.html opentelekomcloud_as_policy_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AsPolicyV1Config);
    private _alarmId?;
    /**
     * @stability stable
     */
    get alarmId(): string | undefined;
    /**
     * @stability stable
     */
    set alarmId(value: string | undefined);
    /**
     * @stability stable
     */
    resetAlarmId(): void;
    /**
     * @stability stable
     */
    get alarmIdInput(): string | undefined;
    private _coolDownTime?;
    /**
     * @stability stable
     */
    get coolDownTime(): number | undefined;
    /**
     * @stability stable
     */
    set coolDownTime(value: number | undefined);
    /**
     * @stability stable
     */
    resetCoolDownTime(): void;
    /**
     * @stability stable
     */
    get coolDownTimeInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _scalingGroupId?;
    /**
     * @stability stable
     */
    get scalingGroupId(): string;
    /**
     * @stability stable
     */
    set scalingGroupId(value: string);
    /**
     * @stability stable
     */
    get scalingGroupIdInput(): string | undefined;
    private _scalingPolicyName?;
    /**
     * @stability stable
     */
    get scalingPolicyName(): string;
    /**
     * @stability stable
     */
    set scalingPolicyName(value: string);
    /**
     * @stability stable
     */
    get scalingPolicyNameInput(): string | undefined;
    private _scalingPolicyType?;
    /**
     * @stability stable
     */
    get scalingPolicyType(): string;
    /**
     * @stability stable
     */
    set scalingPolicyType(value: string);
    /**
     * @stability stable
     */
    get scalingPolicyTypeInput(): string | undefined;
    private _scalingPolicyAction?;
    private __scalingPolicyActionOutput;
    /**
     * @stability stable
     */
    get scalingPolicyAction(): AsPolicyV1ScalingPolicyActionOutputReference;
    /**
     * @stability stable
     */
    putScalingPolicyAction(value: AsPolicyV1ScalingPolicyAction | undefined): void;
    /**
     * @stability stable
     */
    resetScalingPolicyAction(): void;
    /**
     * @stability stable
     */
    get scalingPolicyActionInput(): AsPolicyV1ScalingPolicyAction | undefined;
    private _scheduledPolicy?;
    private __scheduledPolicyOutput;
    /**
     * @stability stable
     */
    get scheduledPolicy(): AsPolicyV1ScheduledPolicyOutputReference;
    /**
     * @stability stable
     */
    putScheduledPolicy(value: AsPolicyV1ScheduledPolicy | undefined): void;
    /**
     * @stability stable
     */
    resetScheduledPolicy(): void;
    /**
     * @stability stable
     */
    get scheduledPolicyInput(): AsPolicyV1ScheduledPolicy | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
