import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AsPolicyV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2.html#alarm_id AsPolicyV2#alarm_id}.
     *
     * @stability stable
     */
    readonly alarmId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2.html#cool_down_time AsPolicyV2#cool_down_time}.
     *
     * @stability stable
     */
    readonly coolDownTime?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2.html#region AsPolicyV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2.html#scaling_policy_name AsPolicyV2#scaling_policy_name}.
     *
     * @stability stable
     */
    readonly scalingPolicyName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2.html#scaling_policy_type AsPolicyV2#scaling_policy_type}.
     *
     * @stability stable
     */
    readonly scalingPolicyType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2.html#scaling_resource_id AsPolicyV2#scaling_resource_id}.
     *
     * @stability stable
     */
    readonly scalingResourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2.html#scaling_resource_type AsPolicyV2#scaling_resource_type}.
     *
     * @stability stable
     */
    readonly scalingResourceType: string;
    /**
     * scaling_policy_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2.html#scaling_policy_action AsPolicyV2#scaling_policy_action}
     *
     * @stability stable
     */
    readonly scalingPolicyAction?: AsPolicyV2ScalingPolicyAction[];
    /**
     * scheduled_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2.html#scheduled_policy AsPolicyV2#scheduled_policy}
     *
     * @stability stable
     */
    readonly scheduledPolicy?: AsPolicyV2ScheduledPolicy[];
}
/**
 * @stability stable
 */
export declare class AsPolicyV2Metadata extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get bandwidthShareType(): string;
    /**
     * @stability stable
     */
    get eipAddress(): string;
    /**
     * @stability stable
     */
    get eipId(): string;
}
/**
 * @stability stable
 */
export interface AsPolicyV2ScalingPolicyAction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2.html#limits AsPolicyV2#limits}.
     *
     * @stability stable
     */
    readonly limits?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2.html#operation AsPolicyV2#operation}.
     *
     * @stability stable
     */
    readonly operation?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2.html#percentage AsPolicyV2#percentage}.
     *
     * @stability stable
     */
    readonly percentage?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2.html#size AsPolicyV2#size}.
     *
     * @stability stable
     */
    readonly size?: number;
}
/**
 * @stability stable
 */
export interface AsPolicyV2ScheduledPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2.html#end_time AsPolicyV2#end_time}.
     *
     * @stability stable
     */
    readonly endTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2.html#launch_time AsPolicyV2#launch_time}.
     *
     * @stability stable
     */
    readonly launchTime: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2.html#recurrence_type AsPolicyV2#recurrence_type}.
     *
     * @stability stable
     */
    readonly recurrenceType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2.html#recurrence_value AsPolicyV2#recurrence_value}.
     *
     * @stability stable
     */
    readonly recurrenceValue?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2.html#start_time AsPolicyV2#start_time}.
     *
     * @stability stable
     */
    readonly startTime?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2.html opentelekomcloud_as_policy_v2}.
 *
 * @stability stable
 */
export declare class AsPolicyV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/as_policy_v2.html opentelekomcloud_as_policy_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AsPolicyV2Config);
    private _alarmId?;
    /**
     * @stability stable
     */
    get alarmId(): string | undefined;
    /**
     * @stability stable
     */
    set alarmId(value: string | undefined);
    /**
     * @stability stable
     */
    resetAlarmId(): void;
    /**
     * @stability stable
     */
    get alarmIdInput(): string | undefined;
    private _coolDownTime?;
    /**
     * @stability stable
     */
    get coolDownTime(): number | undefined;
    /**
     * @stability stable
     */
    set coolDownTime(value: number | undefined);
    /**
     * @stability stable
     */
    resetCoolDownTime(): void;
    /**
     * @stability stable
     */
    get coolDownTimeInput(): number | undefined;
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    metadata(index: string): AsPolicyV2Metadata;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _scalingPolicyName?;
    /**
     * @stability stable
     */
    get scalingPolicyName(): string;
    /**
     * @stability stable
     */
    set scalingPolicyName(value: string);
    /**
     * @stability stable
     */
    get scalingPolicyNameInput(): string | undefined;
    private _scalingPolicyType?;
    /**
     * @stability stable
     */
    get scalingPolicyType(): string;
    /**
     * @stability stable
     */
    set scalingPolicyType(value: string);
    /**
     * @stability stable
     */
    get scalingPolicyTypeInput(): string | undefined;
    private _scalingResourceId?;
    /**
     * @stability stable
     */
    get scalingResourceId(): string;
    /**
     * @stability stable
     */
    set scalingResourceId(value: string);
    /**
     * @stability stable
     */
    get scalingResourceIdInput(): string | undefined;
    private _scalingResourceType?;
    /**
     * @stability stable
     */
    get scalingResourceType(): string;
    /**
     * @stability stable
     */
    set scalingResourceType(value: string);
    /**
     * @stability stable
     */
    get scalingResourceTypeInput(): string | undefined;
    private _scalingPolicyAction?;
    /**
     * @stability stable
     */
    get scalingPolicyAction(): AsPolicyV2ScalingPolicyAction[] | undefined;
    /**
     * @stability stable
     */
    set scalingPolicyAction(value: AsPolicyV2ScalingPolicyAction[] | undefined);
    /**
     * @stability stable
     */
    resetScalingPolicyAction(): void;
    /**
     * @stability stable
     */
    get scalingPolicyActionInput(): AsPolicyV2ScalingPolicyAction[] | undefined;
    private _scheduledPolicy?;
    /**
     * @stability stable
     */
    get scheduledPolicy(): AsPolicyV2ScheduledPolicy[] | undefined;
    /**
     * @stability stable
     */
    set scheduledPolicy(value: AsPolicyV2ScheduledPolicy[] | undefined);
    /**
     * @stability stable
     */
    resetScheduledPolicy(): void;
    /**
     * @stability stable
     */
    get scheduledPolicyInput(): AsPolicyV2ScheduledPolicy[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
