import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BlockstorageVolumeV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/blockstorage_volume_v2.html#availability_zone BlockstorageVolumeV2#availability_zone}.
     *
     * @stability stable
     */
    readonly availabilityZone?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/blockstorage_volume_v2.html#cascade BlockstorageVolumeV2#cascade}.
     *
     * @stability stable
     */
    readonly cascade?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/blockstorage_volume_v2.html#consistency_group_id BlockstorageVolumeV2#consistency_group_id}.
     *
     * @stability stable
     */
    readonly consistencyGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/blockstorage_volume_v2.html#description BlockstorageVolumeV2#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/blockstorage_volume_v2.html#device_type BlockstorageVolumeV2#device_type}.
     *
     * @stability stable
     */
    readonly deviceType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/blockstorage_volume_v2.html#image_id BlockstorageVolumeV2#image_id}.
     *
     * @stability stable
     */
    readonly imageId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/blockstorage_volume_v2.html#metadata BlockstorageVolumeV2#metadata}.
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/blockstorage_volume_v2.html#name BlockstorageVolumeV2#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/blockstorage_volume_v2.html#region BlockstorageVolumeV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/blockstorage_volume_v2.html#size BlockstorageVolumeV2#size}.
     *
     * @stability stable
     */
    readonly size: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/blockstorage_volume_v2.html#snapshot_id BlockstorageVolumeV2#snapshot_id}.
     *
     * @stability stable
     */
    readonly snapshotId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/blockstorage_volume_v2.html#source_replica BlockstorageVolumeV2#source_replica}.
     *
     * @stability stable
     */
    readonly sourceReplica?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/blockstorage_volume_v2.html#source_vol_id BlockstorageVolumeV2#source_vol_id}.
     *
     * @stability stable
     */
    readonly sourceVolId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/blockstorage_volume_v2.html#tags BlockstorageVolumeV2#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/blockstorage_volume_v2.html#volume_type BlockstorageVolumeV2#volume_type}.
     *
     * @stability stable
     */
    readonly volumeType?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/blockstorage_volume_v2.html#timeouts BlockstorageVolumeV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BlockstorageVolumeV2Timeouts;
}
/**
 * @stability stable
 */
export declare class BlockstorageVolumeV2Attachment extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get device(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get instanceId(): string;
}
/**
 * @stability stable
 */
export interface BlockstorageVolumeV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/blockstorage_volume_v2.html#create BlockstorageVolumeV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/blockstorage_volume_v2.html#delete BlockstorageVolumeV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class BlockstorageVolumeV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/blockstorage_volume_v2.html opentelekomcloud_blockstorage_volume_v2}.
 *
 * @stability stable
 */
export declare class BlockstorageVolumeV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/blockstorage_volume_v2.html opentelekomcloud_blockstorage_volume_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BlockstorageVolumeV2Config);
    /**
     * @stability stable
     */
    attachment(index: string): BlockstorageVolumeV2Attachment;
    private _availabilityZone?;
    /**
     * @stability stable
     */
    get availabilityZone(): string | undefined;
    /**
     * @stability stable
     */
    set availabilityZone(value: string | undefined);
    /**
     * @stability stable
     */
    resetAvailabilityZone(): void;
    /**
     * @stability stable
     */
    get availabilityZoneInput(): string | undefined;
    private _cascade?;
    /**
     * @stability stable
     */
    get cascade(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set cascade(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetCascade(): void;
    /**
     * @stability stable
     */
    get cascadeInput(): boolean | cdktf.IResolvable | undefined;
    private _consistencyGroupId?;
    /**
     * @stability stable
     */
    get consistencyGroupId(): string | undefined;
    /**
     * @stability stable
     */
    set consistencyGroupId(value: string | undefined);
    /**
     * @stability stable
     */
    resetConsistencyGroupId(): void;
    /**
     * @stability stable
     */
    get consistencyGroupIdInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _deviceType?;
    /**
     * @stability stable
     */
    get deviceType(): string | undefined;
    /**
     * @stability stable
     */
    set deviceType(value: string | undefined);
    /**
     * @stability stable
     */
    resetDeviceType(): void;
    /**
     * @stability stable
     */
    get deviceTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _imageId?;
    /**
     * @stability stable
     */
    get imageId(): string | undefined;
    /**
     * @stability stable
     */
    set imageId(value: string | undefined);
    /**
     * @stability stable
     */
    resetImageId(): void;
    /**
     * @stability stable
     */
    get imageIdInput(): string | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _size?;
    /**
     * @stability stable
     */
    get size(): number;
    /**
     * @stability stable
     */
    set size(value: number);
    /**
     * @stability stable
     */
    get sizeInput(): number | undefined;
    private _snapshotId?;
    /**
     * @stability stable
     */
    get snapshotId(): string | undefined;
    /**
     * @stability stable
     */
    set snapshotId(value: string | undefined);
    /**
     * @stability stable
     */
    resetSnapshotId(): void;
    /**
     * @stability stable
     */
    get snapshotIdInput(): string | undefined;
    private _sourceReplica?;
    /**
     * @stability stable
     */
    get sourceReplica(): string | undefined;
    /**
     * @stability stable
     */
    set sourceReplica(value: string | undefined);
    /**
     * @stability stable
     */
    resetSourceReplica(): void;
    /**
     * @stability stable
     */
    get sourceReplicaInput(): string | undefined;
    private _sourceVolId?;
    /**
     * @stability stable
     */
    get sourceVolId(): string | undefined;
    /**
     * @stability stable
     */
    set sourceVolId(value: string | undefined);
    /**
     * @stability stable
     */
    resetSourceVolId(): void;
    /**
     * @stability stable
     */
    get sourceVolIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _volumeType?;
    /**
     * @stability stable
     */
    get volumeType(): string | undefined;
    /**
     * @stability stable
     */
    set volumeType(value: string | undefined);
    /**
     * @stability stable
     */
    resetVolumeType(): void;
    /**
     * @stability stable
     */
    get volumeTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get wwn(): string;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): BlockstorageVolumeV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BlockstorageVolumeV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BlockstorageVolumeV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
