import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CbrPolicyV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3.html#enabled CbrPolicyV3#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3.html#name CbrPolicyV3#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3.html#operation_type CbrPolicyV3#operation_type}.
     *
     * @stability stable
     */
    readonly operationType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3.html#trigger_pattern CbrPolicyV3#trigger_pattern}.
     *
     * @stability stable
     */
    readonly triggerPattern: string[];
    /**
     * operation_definition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3.html#operation_definition CbrPolicyV3#operation_definition}
     *
     * @stability stable
     */
    readonly operationDefinition?: CbrPolicyV3OperationDefinition;
}
/**
 * @stability stable
 */
export interface CbrPolicyV3OperationDefinition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3.html#day_backups CbrPolicyV3#day_backups}.
     *
     * @stability stable
     */
    readonly dayBackups?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3.html#max_backups CbrPolicyV3#max_backups}.
     *
     * @stability stable
     */
    readonly maxBackups?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3.html#month_backups CbrPolicyV3#month_backups}.
     *
     * @stability stable
     */
    readonly monthBackups?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3.html#retention_duration_days CbrPolicyV3#retention_duration_days}.
     *
     * @stability stable
     */
    readonly retentionDurationDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3.html#timezone CbrPolicyV3#timezone}.
     *
     * @stability stable
     */
    readonly timezone: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3.html#week_backups CbrPolicyV3#week_backups}.
     *
     * @stability stable
     */
    readonly weekBackups?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3.html#year_backups CbrPolicyV3#year_backups}.
     *
     * @stability stable
     */
    readonly yearBackups?: number;
}
/**
 * @stability stable
 */
export declare class CbrPolicyV3OperationDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _dayBackups?;
    /**
     * @stability stable
     */
    get dayBackups(): number | undefined;
    /**
     * @stability stable
     */
    set dayBackups(value: number | undefined);
    /**
     * @stability stable
     */
    resetDayBackups(): void;
    /**
     * @stability stable
     */
    get dayBackupsInput(): number | undefined;
    private _maxBackups?;
    /**
     * @stability stable
     */
    get maxBackups(): number | undefined;
    /**
     * @stability stable
     */
    set maxBackups(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxBackups(): void;
    /**
     * @stability stable
     */
    get maxBackupsInput(): number | undefined;
    private _monthBackups?;
    /**
     * @stability stable
     */
    get monthBackups(): number | undefined;
    /**
     * @stability stable
     */
    set monthBackups(value: number | undefined);
    /**
     * @stability stable
     */
    resetMonthBackups(): void;
    /**
     * @stability stable
     */
    get monthBackupsInput(): number | undefined;
    private _retentionDurationDays?;
    /**
     * @stability stable
     */
    get retentionDurationDays(): number | undefined;
    /**
     * @stability stable
     */
    set retentionDurationDays(value: number | undefined);
    /**
     * @stability stable
     */
    resetRetentionDurationDays(): void;
    /**
     * @stability stable
     */
    get retentionDurationDaysInput(): number | undefined;
    private _timezone?;
    /**
     * @stability stable
     */
    get timezone(): string;
    /**
     * @stability stable
     */
    set timezone(value: string);
    /**
     * @stability stable
     */
    get timezoneInput(): string | undefined;
    private _weekBackups?;
    /**
     * @stability stable
     */
    get weekBackups(): number | undefined;
    /**
     * @stability stable
     */
    set weekBackups(value: number | undefined);
    /**
     * @stability stable
     */
    resetWeekBackups(): void;
    /**
     * @stability stable
     */
    get weekBackupsInput(): number | undefined;
    private _yearBackups?;
    /**
     * @stability stable
     */
    get yearBackups(): number | undefined;
    /**
     * @stability stable
     */
    set yearBackups(value: number | undefined);
    /**
     * @stability stable
     */
    resetYearBackups(): void;
    /**
     * @stability stable
     */
    get yearBackupsInput(): number | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3.html opentelekomcloud_cbr_policy_v3}.
 *
 * @stability stable
 */
export declare class CbrPolicyV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_policy_v3.html opentelekomcloud_cbr_policy_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CbrPolicyV3Config);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operationType?;
    /**
     * @stability stable
     */
    get operationType(): string;
    /**
     * @stability stable
     */
    set operationType(value: string);
    /**
     * @stability stable
     */
    get operationTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get region(): string;
    private _triggerPattern?;
    /**
     * @stability stable
     */
    get triggerPattern(): string[];
    /**
     * @stability stable
     */
    set triggerPattern(value: string[]);
    /**
     * @stability stable
     */
    get triggerPatternInput(): string[] | undefined;
    private _operationDefinition?;
    private __operationDefinitionOutput;
    /**
     * @stability stable
     */
    get operationDefinition(): CbrPolicyV3OperationDefinitionOutputReference;
    /**
     * @stability stable
     */
    putOperationDefinition(value: CbrPolicyV3OperationDefinition | undefined): void;
    /**
     * @stability stable
     */
    resetOperationDefinition(): void;
    /**
     * @stability stable
     */
    get operationDefinitionInput(): CbrPolicyV3OperationDefinition | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
