import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CbrVaultV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#auto_bind CbrVaultV3#auto_bind}.
     *
     * @stability stable
     */
    readonly autoBind?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#auto_expand CbrVaultV3#auto_expand}.
     *
     * @stability stable
     */
    readonly autoExpand?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#backup_policy_id CbrVaultV3#backup_policy_id}.
     *
     * @stability stable
     */
    readonly backupPolicyId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#description CbrVaultV3#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#enterprise_project_id CbrVaultV3#enterprise_project_id}.
     *
     * @stability stable
     */
    readonly enterpriseProjectId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#name CbrVaultV3#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#resource CbrVaultV3#resource}.
     *
     * @stability stable
     */
    readonly resource?: CbrVaultV3Resource[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#tags CbrVaultV3#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * billing block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#billing CbrVaultV3#billing}
     *
     * @stability stable
     */
    readonly billing: CbrVaultV3Billing;
    /**
     * bind_rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#bind_rules CbrVaultV3#bind_rules}
     *
     * @stability stable
     */
    readonly bindRules?: CbrVaultV3BindRules[];
}
/**
 * @stability stable
 */
export interface CbrVaultV3Resource {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#backup_count CbrVaultV3#backup_count}.
     *
     * @stability stable
     */
    readonly backupCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#backup_size CbrVaultV3#backup_size}.
     *
     * @stability stable
     */
    readonly backupSize?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#extra_info CbrVaultV3#extra_info}.
     *
     * @stability stable
     */
    readonly extraInfo?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#id CbrVaultV3#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#name CbrVaultV3#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#protect_status CbrVaultV3#protect_status}.
     *
     * @stability stable
     */
    readonly protectStatus?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#size CbrVaultV3#size}.
     *
     * @stability stable
     */
    readonly size?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#type CbrVaultV3#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
/**
 * @stability stable
 */
export interface CbrVaultV3Billing {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#charging_mode CbrVaultV3#charging_mode}.
     *
     * @stability stable
     */
    readonly chargingMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#cloud_type CbrVaultV3#cloud_type}.
     *
     * @stability stable
     */
    readonly cloudType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#consistent_level CbrVaultV3#consistent_level}.
     *
     * @stability stable
     */
    readonly consistentLevel?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#console_url CbrVaultV3#console_url}.
     *
     * @stability stable
     */
    readonly consoleUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#extra_info CbrVaultV3#extra_info}.
     *
     * @stability stable
     */
    readonly extraInfo?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#is_auto_pay CbrVaultV3#is_auto_pay}.
     *
     * @stability stable
     */
    readonly isAutoPay?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#is_auto_renew CbrVaultV3#is_auto_renew}.
     *
     * @stability stable
     */
    readonly isAutoRenew?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#object_type CbrVaultV3#object_type}.
     *
     * @stability stable
     */
    readonly objectType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#period_num CbrVaultV3#period_num}.
     *
     * @stability stable
     */
    readonly periodNum?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#period_type CbrVaultV3#period_type}.
     *
     * @stability stable
     */
    readonly periodType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#protect_type CbrVaultV3#protect_type}.
     *
     * @stability stable
     */
    readonly protectType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#size CbrVaultV3#size}.
     *
     * @stability stable
     */
    readonly size: number;
}
/**
 * @stability stable
 */
export declare class CbrVaultV3BillingOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _chargingMode?;
    /**
     * @stability stable
     */
    get chargingMode(): string | undefined;
    /**
     * @stability stable
     */
    set chargingMode(value: string | undefined);
    /**
     * @stability stable
     */
    resetChargingMode(): void;
    /**
     * @stability stable
     */
    get chargingModeInput(): string | undefined;
    private _cloudType?;
    /**
     * @stability stable
     */
    get cloudType(): string | undefined;
    /**
     * @stability stable
     */
    set cloudType(value: string | undefined);
    /**
     * @stability stable
     */
    resetCloudType(): void;
    /**
     * @stability stable
     */
    get cloudTypeInput(): string | undefined;
    private _consistentLevel?;
    /**
     * @stability stable
     */
    get consistentLevel(): string | undefined;
    /**
     * @stability stable
     */
    set consistentLevel(value: string | undefined);
    /**
     * @stability stable
     */
    resetConsistentLevel(): void;
    /**
     * @stability stable
     */
    get consistentLevelInput(): string | undefined;
    private _consoleUrl?;
    /**
     * @stability stable
     */
    get consoleUrl(): string | undefined;
    /**
     * @stability stable
     */
    set consoleUrl(value: string | undefined);
    /**
     * @stability stable
     */
    resetConsoleUrl(): void;
    /**
     * @stability stable
     */
    get consoleUrlInput(): string | undefined;
    private _extraInfo?;
    /**
     * @stability stable
     */
    get extraInfo(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set extraInfo(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetExtraInfo(): void;
    /**
     * @stability stable
     */
    get extraInfoInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _isAutoPay?;
    /**
     * @stability stable
     */
    get isAutoPay(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isAutoPay(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsAutoPay(): void;
    /**
     * @stability stable
     */
    get isAutoPayInput(): boolean | cdktf.IResolvable | undefined;
    private _isAutoRenew?;
    /**
     * @stability stable
     */
    get isAutoRenew(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isAutoRenew(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsAutoRenew(): void;
    /**
     * @stability stable
     */
    get isAutoRenewInput(): boolean | cdktf.IResolvable | undefined;
    private _objectType?;
    /**
     * @stability stable
     */
    get objectType(): string;
    /**
     * @stability stable
     */
    set objectType(value: string);
    /**
     * @stability stable
     */
    get objectTypeInput(): string | undefined;
    private _periodNum?;
    /**
     * @stability stable
     */
    get periodNum(): number | undefined;
    /**
     * @stability stable
     */
    set periodNum(value: number | undefined);
    /**
     * @stability stable
     */
    resetPeriodNum(): void;
    /**
     * @stability stable
     */
    get periodNumInput(): number | undefined;
    private _periodType?;
    /**
     * @stability stable
     */
    get periodType(): string | undefined;
    /**
     * @stability stable
     */
    set periodType(value: string | undefined);
    /**
     * @stability stable
     */
    resetPeriodType(): void;
    /**
     * @stability stable
     */
    get periodTypeInput(): string | undefined;
    private _protectType?;
    /**
     * @stability stable
     */
    get protectType(): string;
    /**
     * @stability stable
     */
    set protectType(value: string);
    /**
     * @stability stable
     */
    get protectTypeInput(): string | undefined;
    private _size?;
    /**
     * @stability stable
     */
    get size(): number;
    /**
     * @stability stable
     */
    set size(value: number);
    /**
     * @stability stable
     */
    get sizeInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface CbrVaultV3BindRules {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#key CbrVaultV3#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html#value CbrVaultV3#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html opentelekomcloud_cbr_vault_v3}.
 *
 * @stability stable
 */
export declare class CbrVaultV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cbr_vault_v3.html opentelekomcloud_cbr_vault_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CbrVaultV3Config);
    private _autoBind?;
    /**
     * @stability stable
     */
    get autoBind(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set autoBind(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAutoBind(): void;
    /**
     * @stability stable
     */
    get autoBindInput(): boolean | cdktf.IResolvable | undefined;
    private _autoExpand?;
    /**
     * @stability stable
     */
    get autoExpand(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set autoExpand(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAutoExpand(): void;
    /**
     * @stability stable
     */
    get autoExpandInput(): boolean | cdktf.IResolvable | undefined;
    private _backupPolicyId?;
    /**
     * @stability stable
     */
    get backupPolicyId(): string | undefined;
    /**
     * @stability stable
     */
    set backupPolicyId(value: string | undefined);
    /**
     * @stability stable
     */
    resetBackupPolicyId(): void;
    /**
     * @stability stable
     */
    get backupPolicyIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get createdAt(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enterpriseProjectId?;
    /**
     * @stability stable
     */
    get enterpriseProjectId(): string | undefined;
    /**
     * @stability stable
     */
    set enterpriseProjectId(value: string | undefined);
    /**
     * @stability stable
     */
    resetEnterpriseProjectId(): void;
    /**
     * @stability stable
     */
    get enterpriseProjectIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get projectId(): string;
    /**
     * @stability stable
     */
    get providerId(): string;
    private _resource?;
    /**
     * @stability stable
     */
    get resource(): CbrVaultV3Resource[] | undefined;
    /**
     * @stability stable
     */
    set resource(value: CbrVaultV3Resource[] | undefined);
    /**
     * @stability stable
     */
    resetResource(): void;
    /**
     * @stability stable
     */
    get resourceInput(): CbrVaultV3Resource[] | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get userId(): string;
    private _billing?;
    private __billingOutput;
    /**
     * @stability stable
     */
    get billing(): CbrVaultV3BillingOutputReference;
    /**
     * @stability stable
     */
    putBilling(value: CbrVaultV3Billing): void;
    /**
     * @stability stable
     */
    get billingInput(): CbrVaultV3Billing | undefined;
    private _bindRules?;
    /**
     * @stability stable
     */
    get bindRules(): CbrVaultV3BindRules[] | undefined;
    /**
     * @stability stable
     */
    set bindRules(value: CbrVaultV3BindRules[] | undefined);
    /**
     * @stability stable
     */
    resetBindRules(): void;
    /**
     * @stability stable
     */
    get bindRulesInput(): CbrVaultV3BindRules[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
