import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CceAddonV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_addon_v3.html#cluster_id CceAddonV3#cluster_id}.
     *
     * @stability stable
     */
    readonly clusterId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_addon_v3.html#template_name CceAddonV3#template_name}.
     *
     * @stability stable
     */
    readonly templateName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_addon_v3.html#template_version CceAddonV3#template_version}.
     *
     * @stability stable
     */
    readonly templateVersion: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_addon_v3.html#timeouts CceAddonV3#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CceAddonV3Timeouts;
    /**
     * values block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_addon_v3.html#values CceAddonV3#values}
     *
     * @stability stable
     */
    readonly values: CceAddonV3Values;
}
/**
 * @stability stable
 */
export interface CceAddonV3Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_addon_v3.html#delete CceAddonV3#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class CceAddonV3TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CceAddonV3Values {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_addon_v3.html#basic CceAddonV3#basic}.
     *
     * @stability stable
     */
    readonly basic: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_addon_v3.html#custom CceAddonV3#custom}.
     *
     * @stability stable
     */
    readonly custom: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class CceAddonV3ValuesOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _basic?;
    /**
     * @stability stable
     */
    get basic(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set basic(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get basicInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _custom?;
    /**
     * @stability stable
     */
    get custom(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set custom(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get customInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_addon_v3.html opentelekomcloud_cce_addon_v3}.
 *
 * @stability stable
 */
export declare class CceAddonV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_addon_v3.html opentelekomcloud_cce_addon_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CceAddonV3Config);
    private _clusterId?;
    /**
     * @stability stable
     */
    get clusterId(): string;
    /**
     * @stability stable
     */
    set clusterId(value: string);
    /**
     * @stability stable
     */
    get clusterIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _templateName?;
    /**
     * @stability stable
     */
    get templateName(): string;
    /**
     * @stability stable
     */
    set templateName(value: string);
    /**
     * @stability stable
     */
    get templateNameInput(): string | undefined;
    private _templateVersion?;
    /**
     * @stability stable
     */
    get templateVersion(): string;
    /**
     * @stability stable
     */
    set templateVersion(value: string);
    /**
     * @stability stable
     */
    get templateVersionInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): CceAddonV3TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CceAddonV3Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CceAddonV3Timeouts | undefined;
    private _values?;
    private __valuesOutput;
    /**
     * @stability stable
     */
    get values(): CceAddonV3ValuesOutputReference;
    /**
     * @stability stable
     */
    putValues(value: CceAddonV3Values): void;
    /**
     * @stability stable
     */
    get valuesInput(): CceAddonV3Values | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
