import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CceClusterV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#annotations CceClusterV3#annotations}.
     *
     * @stability stable
     */
    readonly annotations?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#authenticating_proxy_ca CceClusterV3#authenticating_proxy_ca}.
     *
     * @stability stable
     */
    readonly authenticatingProxyCa?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#authentication_mode CceClusterV3#authentication_mode}.
     *
     * @stability stable
     */
    readonly authenticationMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#billing_mode CceClusterV3#billing_mode}.
     *
     * @stability stable
     */
    readonly billingMode?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#cluster_type CceClusterV3#cluster_type}.
     *
     * @stability stable
     */
    readonly clusterType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#cluster_version CceClusterV3#cluster_version}.
     *
     * @stability stable
     */
    readonly clusterVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#container_network_cidr CceClusterV3#container_network_cidr}.
     *
     * @stability stable
     */
    readonly containerNetworkCidr?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#container_network_type CceClusterV3#container_network_type}.
     *
     * @stability stable
     */
    readonly containerNetworkType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#description CceClusterV3#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#eip CceClusterV3#eip}.
     *
     * @stability stable
     */
    readonly eip?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#extend_param CceClusterV3#extend_param}.
     *
     * @stability stable
     */
    readonly extendParam?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#flavor_id CceClusterV3#flavor_id}.
     *
     * @stability stable
     */
    readonly flavorId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#highway_subnet_id CceClusterV3#highway_subnet_id}.
     *
     * @stability stable
     */
    readonly highwaySubnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#ignore_addons CceClusterV3#ignore_addons}.
     *
     * @stability stable
     */
    readonly ignoreAddons?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#kubernetes_svc_ip_range CceClusterV3#kubernetes_svc_ip_range}.
     *
     * @stability stable
     */
    readonly kubernetesSvcIpRange?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#labels CceClusterV3#labels}.
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#multi_az CceClusterV3#multi_az}.
     *
     * @stability stable
     */
    readonly multiAz?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#name CceClusterV3#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#no_addons CceClusterV3#no_addons}.
     *
     * @stability stable
     */
    readonly noAddons?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#region CceClusterV3#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#subnet_id CceClusterV3#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#vpc_id CceClusterV3#vpc_id}.
     *
     * @stability stable
     */
    readonly vpcId: string;
    /**
     * authenticating_proxy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#authenticating_proxy CceClusterV3#authenticating_proxy}
     *
     * @stability stable
     */
    readonly authenticatingProxy?: CceClusterV3AuthenticatingProxy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#timeouts CceClusterV3#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CceClusterV3Timeouts;
}
/**
 * @stability stable
 */
export declare class CceClusterV3CertificateClusters extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get certificateAuthorityData(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get server(): string;
}
/**
 * @stability stable
 */
export declare class CceClusterV3CertificateUsers extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get clientCertificateData(): string;
    /**
     * @stability stable
     */
    get clientKeyData(): string;
    /**
     * @stability stable
     */
    get name(): string;
}
/**
 * @stability stable
 */
export interface CceClusterV3AuthenticatingProxy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#ca CceClusterV3#ca}.
     *
     * @stability stable
     */
    readonly ca: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#cert CceClusterV3#cert}.
     *
     * @stability stable
     */
    readonly cert: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#private_key CceClusterV3#private_key}.
     *
     * @stability stable
     */
    readonly privateKey: string;
}
/**
 * @stability stable
 */
export declare class CceClusterV3AuthenticatingProxyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _ca?;
    /**
     * @stability stable
     */
    get ca(): string;
    /**
     * @stability stable
     */
    set ca(value: string);
    /**
     * @stability stable
     */
    get caInput(): string | undefined;
    private _cert?;
    /**
     * @stability stable
     */
    get cert(): string;
    /**
     * @stability stable
     */
    set cert(value: string);
    /**
     * @stability stable
     */
    get certInput(): string | undefined;
    private _privateKey?;
    /**
     * @stability stable
     */
    get privateKey(): string;
    /**
     * @stability stable
     */
    set privateKey(value: string);
    /**
     * @stability stable
     */
    get privateKeyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CceClusterV3Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#create CceClusterV3#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html#delete CceClusterV3#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class CceClusterV3TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html opentelekomcloud_cce_cluster_v3}.
 *
 * @stability stable
 */
export declare class CceClusterV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_cluster_v3.html opentelekomcloud_cce_cluster_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CceClusterV3Config);
    private _annotations?;
    /**
     * @stability stable
     */
    get annotations(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set annotations(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAnnotations(): void;
    /**
     * @stability stable
     */
    get annotationsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _authenticatingProxyCa?;
    /**
     * @stability stable
     */
    get authenticatingProxyCa(): string | undefined;
    /**
     * @stability stable
     */
    set authenticatingProxyCa(value: string | undefined);
    /**
     * @stability stable
     */
    resetAuthenticatingProxyCa(): void;
    /**
     * @stability stable
     */
    get authenticatingProxyCaInput(): string | undefined;
    private _authenticationMode?;
    /**
     * @stability stable
     */
    get authenticationMode(): string | undefined;
    /**
     * @stability stable
     */
    set authenticationMode(value: string | undefined);
    /**
     * @stability stable
     */
    resetAuthenticationMode(): void;
    /**
     * @stability stable
     */
    get authenticationModeInput(): string | undefined;
    private _billingMode?;
    /**
     * @stability stable
     */
    get billingMode(): number | undefined;
    /**
     * @stability stable
     */
    set billingMode(value: number | undefined);
    /**
     * @stability stable
     */
    resetBillingMode(): void;
    /**
     * @stability stable
     */
    get billingModeInput(): number | undefined;
    /**
     * @stability stable
     */
    certificateClusters(index: string): CceClusterV3CertificateClusters;
    /**
     * @stability stable
     */
    certificateUsers(index: string): CceClusterV3CertificateUsers;
    private _clusterType?;
    /**
     * @stability stable
     */
    get clusterType(): string;
    /**
     * @stability stable
     */
    set clusterType(value: string);
    /**
     * @stability stable
     */
    get clusterTypeInput(): string | undefined;
    private _clusterVersion?;
    /**
     * @stability stable
     */
    get clusterVersion(): string | undefined;
    /**
     * @stability stable
     */
    set clusterVersion(value: string | undefined);
    /**
     * @stability stable
     */
    resetClusterVersion(): void;
    /**
     * @stability stable
     */
    get clusterVersionInput(): string | undefined;
    private _containerNetworkCidr?;
    /**
     * @stability stable
     */
    get containerNetworkCidr(): string | undefined;
    /**
     * @stability stable
     */
    set containerNetworkCidr(value: string | undefined);
    /**
     * @stability stable
     */
    resetContainerNetworkCidr(): void;
    /**
     * @stability stable
     */
    get containerNetworkCidrInput(): string | undefined;
    private _containerNetworkType?;
    /**
     * @stability stable
     */
    get containerNetworkType(): string;
    /**
     * @stability stable
     */
    set containerNetworkType(value: string);
    /**
     * @stability stable
     */
    get containerNetworkTypeInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _eip?;
    /**
     * @stability stable
     */
    get eip(): string | undefined;
    /**
     * @stability stable
     */
    set eip(value: string | undefined);
    /**
     * @stability stable
     */
    resetEip(): void;
    /**
     * @stability stable
     */
    get eipInput(): string | undefined;
    private _extendParam?;
    /**
     * @stability stable
     */
    get extendParam(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set extendParam(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetExtendParam(): void;
    /**
     * @stability stable
     */
    get extendParamInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get external(): string;
    /**
     * @stability stable
     */
    get externalOtc(): string;
    private _flavorId?;
    /**
     * @stability stable
     */
    get flavorId(): string;
    /**
     * @stability stable
     */
    set flavorId(value: string);
    /**
     * @stability stable
     */
    get flavorIdInput(): string | undefined;
    private _highwaySubnetId?;
    /**
     * @stability stable
     */
    get highwaySubnetId(): string | undefined;
    /**
     * @stability stable
     */
    set highwaySubnetId(value: string | undefined);
    /**
     * @stability stable
     */
    resetHighwaySubnetId(): void;
    /**
     * @stability stable
     */
    get highwaySubnetIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ignoreAddons?;
    /**
     * @stability stable
     */
    get ignoreAddons(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set ignoreAddons(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIgnoreAddons(): void;
    /**
     * @stability stable
     */
    get ignoreAddonsInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get installedAddons(): string[];
    /**
     * @stability stable
     */
    get internal(): string;
    /**
     * @stability stable
     */
    get kubeProxyMode(): string;
    private _kubernetesSvcIpRange?;
    /**
     * @stability stable
     */
    get kubernetesSvcIpRange(): string | undefined;
    /**
     * @stability stable
     */
    set kubernetesSvcIpRange(value: string | undefined);
    /**
     * @stability stable
     */
    resetKubernetesSvcIpRange(): void;
    /**
     * @stability stable
     */
    get kubernetesSvcIpRangeInput(): string | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _multiAz?;
    /**
     * @stability stable
     */
    get multiAz(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set multiAz(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetMultiAz(): void;
    /**
     * @stability stable
     */
    get multiAzInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _noAddons?;
    /**
     * @stability stable
     */
    get noAddons(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set noAddons(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetNoAddons(): void;
    /**
     * @stability stable
     */
    get noAddonsInput(): boolean | cdktf.IResolvable | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get securityGroupControl(): string;
    /**
     * @stability stable
     */
    get securityGroupNode(): string;
    /**
     * @stability stable
     */
    get status(): string;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _vpcId?;
    /**
     * @stability stable
     */
    get vpcId(): string;
    /**
     * @stability stable
     */
    set vpcId(value: string);
    /**
     * @stability stable
     */
    get vpcIdInput(): string | undefined;
    private _authenticatingProxy?;
    private __authenticatingProxyOutput;
    /**
     * @stability stable
     */
    get authenticatingProxy(): CceClusterV3AuthenticatingProxyOutputReference;
    /**
     * @stability stable
     */
    putAuthenticatingProxy(value: CceClusterV3AuthenticatingProxy | undefined): void;
    /**
     * @stability stable
     */
    resetAuthenticatingProxy(): void;
    /**
     * @stability stable
     */
    get authenticatingProxyInput(): CceClusterV3AuthenticatingProxy | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): CceClusterV3TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CceClusterV3Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CceClusterV3Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
