import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CceNodePoolV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#availability_zone CceNodePoolV3#availability_zone}.
     *
     * @stability stable
     */
    readonly availabilityZone?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#cluster_id CceNodePoolV3#cluster_id}.
     *
     * @stability stable
     */
    readonly clusterId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#docker_base_size CceNodePoolV3#docker_base_size}.
     *
     * @stability stable
     */
    readonly dockerBaseSize?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#docker_lvm_config_override CceNodePoolV3#docker_lvm_config_override}.
     *
     * @stability stable
     */
    readonly dockerLvmConfigOverride?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#flavor CceNodePoolV3#flavor}.
     *
     * @stability stable
     */
    readonly flavor: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#initial_node_count CceNodePoolV3#initial_node_count}.
     *
     * @stability stable
     */
    readonly initialNodeCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#k8s_tags CceNodePoolV3#k8s_tags}.
     *
     * @stability stable
     */
    readonly k8STags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#key_pair CceNodePoolV3#key_pair}.
     *
     * @stability stable
     */
    readonly keyPair?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#max_node_count CceNodePoolV3#max_node_count}.
     *
     * @stability stable
     */
    readonly maxNodeCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#max_pods CceNodePoolV3#max_pods}.
     *
     * @stability stable
     */
    readonly maxPods?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#min_node_count CceNodePoolV3#min_node_count}.
     *
     * @stability stable
     */
    readonly minNodeCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#name CceNodePoolV3#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#os CceNodePoolV3#os}.
     *
     * @stability stable
     */
    readonly os?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#password CceNodePoolV3#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#postinstall CceNodePoolV3#postinstall}.
     *
     * @stability stable
     */
    readonly postinstall?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#preinstall CceNodePoolV3#preinstall}.
     *
     * @stability stable
     */
    readonly preinstall?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#priority CceNodePoolV3#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#scale_down_cooldown_time CceNodePoolV3#scale_down_cooldown_time}.
     *
     * @stability stable
     */
    readonly scaleDownCooldownTime?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#scale_enable CceNodePoolV3#scale_enable}.
     *
     * @stability stable
     */
    readonly scaleEnable?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#server_group_reference CceNodePoolV3#server_group_reference}.
     *
     * @stability stable
     */
    readonly serverGroupReference?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#subnet_id CceNodePoolV3#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#user_tags CceNodePoolV3#user_tags}.
     *
     * @stability stable
     */
    readonly userTags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * data_volumes block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#data_volumes CceNodePoolV3#data_volumes}
     *
     * @stability stable
     */
    readonly dataVolumes: CceNodePoolV3DataVolumes[];
    /**
     * root_volume block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#root_volume CceNodePoolV3#root_volume}
     *
     * @stability stable
     */
    readonly rootVolume: CceNodePoolV3RootVolume;
    /**
     * taints block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#taints CceNodePoolV3#taints}
     *
     * @stability stable
     */
    readonly taints?: CceNodePoolV3Taints[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#timeouts CceNodePoolV3#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CceNodePoolV3Timeouts;
}
/**
 * @stability stable
 */
export interface CceNodePoolV3DataVolumes {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#extend_param CceNodePoolV3#extend_param}.
     *
     * @stability stable
     */
    readonly extendParam?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#kms_id CceNodePoolV3#kms_id}.
     *
     * @stability stable
     */
    readonly kmsId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#size CceNodePoolV3#size}.
     *
     * @stability stable
     */
    readonly size: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#volumetype CceNodePoolV3#volumetype}.
     *
     * @stability stable
     */
    readonly volumetype: string;
}
/**
 * @stability stable
 */
export interface CceNodePoolV3RootVolume {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#extend_param CceNodePoolV3#extend_param}.
     *
     * @stability stable
     */
    readonly extendParam?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#size CceNodePoolV3#size}.
     *
     * @stability stable
     */
    readonly size: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#volumetype CceNodePoolV3#volumetype}.
     *
     * @stability stable
     */
    readonly volumetype: string;
}
/**
 * @stability stable
 */
export declare class CceNodePoolV3RootVolumeOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _extendParam?;
    /**
     * @stability stable
     */
    get extendParam(): string | undefined;
    /**
     * @stability stable
     */
    set extendParam(value: string | undefined);
    /**
     * @stability stable
     */
    resetExtendParam(): void;
    /**
     * @stability stable
     */
    get extendParamInput(): string | undefined;
    private _size?;
    /**
     * @stability stable
     */
    get size(): number;
    /**
     * @stability stable
     */
    set size(value: number);
    /**
     * @stability stable
     */
    get sizeInput(): number | undefined;
    private _volumetype?;
    /**
     * @stability stable
     */
    get volumetype(): string;
    /**
     * @stability stable
     */
    set volumetype(value: string);
    /**
     * @stability stable
     */
    get volumetypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CceNodePoolV3Taints {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#effect CceNodePoolV3#effect}.
     *
     * @stability stable
     */
    readonly effect: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#key CceNodePoolV3#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#value CceNodePoolV3#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface CceNodePoolV3Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#create CceNodePoolV3#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#default CceNodePoolV3#default}.
     *
     * @stability stable
     */
    readonly default?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#delete CceNodePoolV3#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html#update CceNodePoolV3#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class CceNodePoolV3TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _default?;
    /**
     * @stability stable
     */
    get default(): string | undefined;
    /**
     * @stability stable
     */
    set default(value: string | undefined);
    /**
     * @stability stable
     */
    resetDefault(): void;
    /**
     * @stability stable
     */
    get defaultInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html opentelekomcloud_cce_node_pool_v3}.
 *
 * @stability stable
 */
export declare class CceNodePoolV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_pool_v3.html opentelekomcloud_cce_node_pool_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CceNodePoolV3Config);
    private _availabilityZone?;
    /**
     * @stability stable
     */
    get availabilityZone(): string | undefined;
    /**
     * @stability stable
     */
    set availabilityZone(value: string | undefined);
    /**
     * @stability stable
     */
    resetAvailabilityZone(): void;
    /**
     * @stability stable
     */
    get availabilityZoneInput(): string | undefined;
    private _clusterId?;
    /**
     * @stability stable
     */
    get clusterId(): string;
    /**
     * @stability stable
     */
    set clusterId(value: string);
    /**
     * @stability stable
     */
    get clusterIdInput(): string | undefined;
    private _dockerBaseSize?;
    /**
     * @stability stable
     */
    get dockerBaseSize(): number | undefined;
    /**
     * @stability stable
     */
    set dockerBaseSize(value: number | undefined);
    /**
     * @stability stable
     */
    resetDockerBaseSize(): void;
    /**
     * @stability stable
     */
    get dockerBaseSizeInput(): number | undefined;
    private _dockerLvmConfigOverride?;
    /**
     * @stability stable
     */
    get dockerLvmConfigOverride(): string | undefined;
    /**
     * @stability stable
     */
    set dockerLvmConfigOverride(value: string | undefined);
    /**
     * @stability stable
     */
    resetDockerLvmConfigOverride(): void;
    /**
     * @stability stable
     */
    get dockerLvmConfigOverrideInput(): string | undefined;
    private _flavor?;
    /**
     * @stability stable
     */
    get flavor(): string;
    /**
     * @stability stable
     */
    set flavor(value: string);
    /**
     * @stability stable
     */
    get flavorInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _initialNodeCount?;
    /**
     * @stability stable
     */
    get initialNodeCount(): number;
    /**
     * @stability stable
     */
    set initialNodeCount(value: number);
    /**
     * @stability stable
     */
    get initialNodeCountInput(): number | undefined;
    private _k8STags?;
    /**
     * @stability stable
     */
    get k8STags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set k8STags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetK8STags(): void;
    /**
     * @stability stable
     */
    get k8STagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _keyPair?;
    /**
     * @stability stable
     */
    get keyPair(): string | undefined;
    /**
     * @stability stable
     */
    set keyPair(value: string | undefined);
    /**
     * @stability stable
     */
    resetKeyPair(): void;
    /**
     * @stability stable
     */
    get keyPairInput(): string | undefined;
    private _maxNodeCount?;
    /**
     * @stability stable
     */
    get maxNodeCount(): number | undefined;
    /**
     * @stability stable
     */
    set maxNodeCount(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxNodeCount(): void;
    /**
     * @stability stable
     */
    get maxNodeCountInput(): number | undefined;
    private _maxPods?;
    /**
     * @stability stable
     */
    get maxPods(): number | undefined;
    /**
     * @stability stable
     */
    set maxPods(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxPods(): void;
    /**
     * @stability stable
     */
    get maxPodsInput(): number | undefined;
    private _minNodeCount?;
    /**
     * @stability stable
     */
    get minNodeCount(): number | undefined;
    /**
     * @stability stable
     */
    set minNodeCount(value: number | undefined);
    /**
     * @stability stable
     */
    resetMinNodeCount(): void;
    /**
     * @stability stable
     */
    get minNodeCountInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _os?;
    /**
     * @stability stable
     */
    get os(): string | undefined;
    /**
     * @stability stable
     */
    set os(value: string | undefined);
    /**
     * @stability stable
     */
    resetOs(): void;
    /**
     * @stability stable
     */
    get osInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string | undefined;
    /**
     * @stability stable
     */
    set password(value: string | undefined);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _postinstall?;
    /**
     * @stability stable
     */
    get postinstall(): string | undefined;
    /**
     * @stability stable
     */
    set postinstall(value: string | undefined);
    /**
     * @stability stable
     */
    resetPostinstall(): void;
    /**
     * @stability stable
     */
    get postinstallInput(): string | undefined;
    private _preinstall?;
    /**
     * @stability stable
     */
    get preinstall(): string | undefined;
    /**
     * @stability stable
     */
    set preinstall(value: string | undefined);
    /**
     * @stability stable
     */
    resetPreinstall(): void;
    /**
     * @stability stable
     */
    get preinstallInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number | undefined;
    /**
     * @stability stable
     */
    set priority(value: number | undefined);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _scaleDownCooldownTime?;
    /**
     * @stability stable
     */
    get scaleDownCooldownTime(): number | undefined;
    /**
     * @stability stable
     */
    set scaleDownCooldownTime(value: number | undefined);
    /**
     * @stability stable
     */
    resetScaleDownCooldownTime(): void;
    /**
     * @stability stable
     */
    get scaleDownCooldownTimeInput(): number | undefined;
    private _scaleEnable?;
    /**
     * @stability stable
     */
    get scaleEnable(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set scaleEnable(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetScaleEnable(): void;
    /**
     * @stability stable
     */
    get scaleEnableInput(): boolean | cdktf.IResolvable | undefined;
    private _serverGroupReference?;
    /**
     * @stability stable
     */
    get serverGroupReference(): string | undefined;
    /**
     * @stability stable
     */
    set serverGroupReference(value: string | undefined);
    /**
     * @stability stable
     */
    resetServerGroupReference(): void;
    /**
     * @stability stable
     */
    get serverGroupReferenceInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string | undefined;
    /**
     * @stability stable
     */
    set subnetId(value: string | undefined);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _userTags?;
    /**
     * @stability stable
     */
    get userTags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set userTags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetUserTags(): void;
    /**
     * @stability stable
     */
    get userTagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _dataVolumes?;
    /**
     * @stability stable
     */
    get dataVolumes(): CceNodePoolV3DataVolumes[];
    /**
     * @stability stable
     */
    set dataVolumes(value: CceNodePoolV3DataVolumes[]);
    /**
     * @stability stable
     */
    get dataVolumesInput(): CceNodePoolV3DataVolumes[] | undefined;
    private _rootVolume?;
    private __rootVolumeOutput;
    /**
     * @stability stable
     */
    get rootVolume(): CceNodePoolV3RootVolumeOutputReference;
    /**
     * @stability stable
     */
    putRootVolume(value: CceNodePoolV3RootVolume): void;
    /**
     * @stability stable
     */
    get rootVolumeInput(): CceNodePoolV3RootVolume | undefined;
    private _taints?;
    /**
     * @stability stable
     */
    get taints(): CceNodePoolV3Taints[] | undefined;
    /**
     * @stability stable
     */
    set taints(value: CceNodePoolV3Taints[] | undefined);
    /**
     * @stability stable
     */
    resetTaints(): void;
    /**
     * @stability stable
     */
    get taintsInput(): CceNodePoolV3Taints[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): CceNodePoolV3TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CceNodePoolV3Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CceNodePoolV3Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
