import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CceNodeV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#annotations CceNodeV3#annotations}.
     *
     * @stability stable
     */
    readonly annotations?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#availability_zone CceNodeV3#availability_zone}.
     *
     * @stability stable
     */
    readonly availabilityZone: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#bandwidth_charge_mode CceNodeV3#bandwidth_charge_mode}.
     *
     * @stability stable
     */
    readonly bandwidthChargeMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#bandwidth_size CceNodeV3#bandwidth_size}.
     *
     * @stability stable
     */
    readonly bandwidthSize?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#billing_mode CceNodeV3#billing_mode}.
     *
     * @stability stable
     */
    readonly billingMode?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#cluster_id CceNodeV3#cluster_id}.
     *
     * @stability stable
     */
    readonly clusterId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#docker_base_size CceNodeV3#docker_base_size}.
     *
     * @stability stable
     */
    readonly dockerBaseSize?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#docker_lvm_config_override CceNodeV3#docker_lvm_config_override}.
     *
     * @stability stable
     */
    readonly dockerLvmConfigOverride?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#ecs_performance_type CceNodeV3#ecs_performance_type}.
     *
     * @stability stable
     */
    readonly ecsPerformanceType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#eip_count CceNodeV3#eip_count}.
     *
     * @stability stable
     */
    readonly eipCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#eip_ids CceNodeV3#eip_ids}.
     *
     * @stability stable
     */
    readonly eipIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#extend_param_charging_mode CceNodeV3#extend_param_charging_mode}.
     *
     * @stability stable
     */
    readonly extendParamChargingMode?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#flavor_id CceNodeV3#flavor_id}.
     *
     * @stability stable
     */
    readonly flavorId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#iptype CceNodeV3#iptype}.
     *
     * @stability stable
     */
    readonly iptype?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#k8s_tags CceNodeV3#k8s_tags}.
     *
     * @stability stable
     */
    readonly k8STags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#key_pair CceNodeV3#key_pair}.
     *
     * @stability stable
     */
    readonly keyPair: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#labels CceNodeV3#labels}.
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#max_pods CceNodeV3#max_pods}.
     *
     * @stability stable
     */
    readonly maxPods?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#name CceNodeV3#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#order_id CceNodeV3#order_id}.
     *
     * @stability stable
     */
    readonly orderId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#os CceNodeV3#os}.
     *
     * @stability stable
     */
    readonly os?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#postinstall CceNodeV3#postinstall}.
     *
     * @stability stable
     */
    readonly postinstall?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#preinstall CceNodeV3#preinstall}.
     *
     * @stability stable
     */
    readonly preinstall?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#private_ip CceNodeV3#private_ip}.
     *
     * @stability stable
     */
    readonly privateIp?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#product_id CceNodeV3#product_id}.
     *
     * @stability stable
     */
    readonly productId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#public_key CceNodeV3#public_key}.
     *
     * @stability stable
     */
    readonly publicKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#region CceNodeV3#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#sharetype CceNodeV3#sharetype}.
     *
     * @stability stable
     */
    readonly sharetype?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#subnet_id CceNodeV3#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#tags CceNodeV3#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * data_volumes block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#data_volumes CceNodeV3#data_volumes}
     *
     * @stability stable
     */
    readonly dataVolumes: CceNodeV3DataVolumes[];
    /**
     * root_volume block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#root_volume CceNodeV3#root_volume}
     *
     * @stability stable
     */
    readonly rootVolume: CceNodeV3RootVolume;
    /**
     * taints block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#taints CceNodeV3#taints}
     *
     * @stability stable
     */
    readonly taints?: CceNodeV3Taints[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#timeouts CceNodeV3#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CceNodeV3Timeouts;
}
/**
 * @stability stable
 */
export interface CceNodeV3DataVolumes {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#extend_param CceNodeV3#extend_param}.
     *
     * @stability stable
     */
    readonly extendParam?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#kms_id CceNodeV3#kms_id}.
     *
     * @stability stable
     */
    readonly kmsId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#size CceNodeV3#size}.
     *
     * @stability stable
     */
    readonly size: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#volumetype CceNodeV3#volumetype}.
     *
     * @stability stable
     */
    readonly volumetype: string;
}
/**
 * @stability stable
 */
export interface CceNodeV3RootVolume {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#extend_param CceNodeV3#extend_param}.
     *
     * @stability stable
     */
    readonly extendParam?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#size CceNodeV3#size}.
     *
     * @stability stable
     */
    readonly size: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#volumetype CceNodeV3#volumetype}.
     *
     * @stability stable
     */
    readonly volumetype: string;
}
/**
 * @stability stable
 */
export declare class CceNodeV3RootVolumeOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _extendParam?;
    /**
     * @stability stable
     */
    get extendParam(): string | undefined;
    /**
     * @stability stable
     */
    set extendParam(value: string | undefined);
    /**
     * @stability stable
     */
    resetExtendParam(): void;
    /**
     * @stability stable
     */
    get extendParamInput(): string | undefined;
    private _size?;
    /**
     * @stability stable
     */
    get size(): number;
    /**
     * @stability stable
     */
    set size(value: number);
    /**
     * @stability stable
     */
    get sizeInput(): number | undefined;
    private _volumetype?;
    /**
     * @stability stable
     */
    get volumetype(): string;
    /**
     * @stability stable
     */
    set volumetype(value: string);
    /**
     * @stability stable
     */
    get volumetypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CceNodeV3Taints {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#effect CceNodeV3#effect}.
     *
     * @stability stable
     */
    readonly effect: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#key CceNodeV3#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#value CceNodeV3#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface CceNodeV3Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#create CceNodeV3#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html#delete CceNodeV3#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class CceNodeV3TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html opentelekomcloud_cce_node_v3}.
 *
 * @stability stable
 */
export declare class CceNodeV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cce_node_v3.html opentelekomcloud_cce_node_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CceNodeV3Config);
    private _annotations?;
    /**
     * @stability stable
     */
    get annotations(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set annotations(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAnnotations(): void;
    /**
     * @stability stable
     */
    get annotationsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _availabilityZone?;
    /**
     * @stability stable
     */
    get availabilityZone(): string;
    /**
     * @stability stable
     */
    set availabilityZone(value: string);
    /**
     * @stability stable
     */
    get availabilityZoneInput(): string | undefined;
    private _bandwidthChargeMode?;
    /**
     * @stability stable
     */
    get bandwidthChargeMode(): string | undefined;
    /**
     * @stability stable
     */
    set bandwidthChargeMode(value: string | undefined);
    /**
     * @stability stable
     */
    resetBandwidthChargeMode(): void;
    /**
     * @stability stable
     */
    get bandwidthChargeModeInput(): string | undefined;
    private _bandwidthSize?;
    /**
     * @stability stable
     */
    get bandwidthSize(): number | undefined;
    /**
     * @stability stable
     */
    set bandwidthSize(value: number | undefined);
    /**
     * @stability stable
     */
    resetBandwidthSize(): void;
    /**
     * @stability stable
     */
    get bandwidthSizeInput(): number | undefined;
    private _billingMode?;
    /**
     * @stability stable
     */
    get billingMode(): number | undefined;
    /**
     * @stability stable
     */
    set billingMode(value: number | undefined);
    /**
     * @stability stable
     */
    resetBillingMode(): void;
    /**
     * @stability stable
     */
    get billingModeInput(): number | undefined;
    private _clusterId?;
    /**
     * @stability stable
     */
    get clusterId(): string;
    /**
     * @stability stable
     */
    set clusterId(value: string);
    /**
     * @stability stable
     */
    get clusterIdInput(): string | undefined;
    private _dockerBaseSize?;
    /**
     * @stability stable
     */
    get dockerBaseSize(): number | undefined;
    /**
     * @stability stable
     */
    set dockerBaseSize(value: number | undefined);
    /**
     * @stability stable
     */
    resetDockerBaseSize(): void;
    /**
     * @stability stable
     */
    get dockerBaseSizeInput(): number | undefined;
    private _dockerLvmConfigOverride?;
    /**
     * @stability stable
     */
    get dockerLvmConfigOverride(): string | undefined;
    /**
     * @stability stable
     */
    set dockerLvmConfigOverride(value: string | undefined);
    /**
     * @stability stable
     */
    resetDockerLvmConfigOverride(): void;
    /**
     * @stability stable
     */
    get dockerLvmConfigOverrideInput(): string | undefined;
    private _ecsPerformanceType?;
    /**
     * @stability stable
     */
    get ecsPerformanceType(): string | undefined;
    /**
     * @stability stable
     */
    set ecsPerformanceType(value: string | undefined);
    /**
     * @stability stable
     */
    resetEcsPerformanceType(): void;
    /**
     * @stability stable
     */
    get ecsPerformanceTypeInput(): string | undefined;
    private _eipCount?;
    /**
     * @stability stable
     */
    get eipCount(): number | undefined;
    /**
     * @stability stable
     */
    set eipCount(value: number | undefined);
    /**
     * @stability stable
     */
    resetEipCount(): void;
    /**
     * @stability stable
     */
    get eipCountInput(): number | undefined;
    private _eipIds?;
    /**
     * @stability stable
     */
    get eipIds(): string[] | undefined;
    /**
     * @stability stable
     */
    set eipIds(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetEipIds(): void;
    /**
     * @stability stable
     */
    get eipIdsInput(): string[] | undefined;
    private _extendParamChargingMode?;
    /**
     * @stability stable
     */
    get extendParamChargingMode(): number | undefined;
    /**
     * @stability stable
     */
    set extendParamChargingMode(value: number | undefined);
    /**
     * @stability stable
     */
    resetExtendParamChargingMode(): void;
    /**
     * @stability stable
     */
    get extendParamChargingModeInput(): number | undefined;
    private _flavorId?;
    /**
     * @stability stable
     */
    get flavorId(): string;
    /**
     * @stability stable
     */
    set flavorId(value: string);
    /**
     * @stability stable
     */
    get flavorIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _iptype?;
    /**
     * @stability stable
     */
    get iptype(): string | undefined;
    /**
     * @stability stable
     */
    set iptype(value: string | undefined);
    /**
     * @stability stable
     */
    resetIptype(): void;
    /**
     * @stability stable
     */
    get iptypeInput(): string | undefined;
    private _k8STags?;
    /**
     * @stability stable
     */
    get k8STags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set k8STags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetK8STags(): void;
    /**
     * @stability stable
     */
    get k8STagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _keyPair?;
    /**
     * @stability stable
     */
    get keyPair(): string;
    /**
     * @stability stable
     */
    set keyPair(value: string);
    /**
     * @stability stable
     */
    get keyPairInput(): string | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _maxPods?;
    /**
     * @stability stable
     */
    get maxPods(): number | undefined;
    /**
     * @stability stable
     */
    set maxPods(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxPods(): void;
    /**
     * @stability stable
     */
    get maxPodsInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _orderId?;
    /**
     * @stability stable
     */
    get orderId(): string | undefined;
    /**
     * @stability stable
     */
    set orderId(value: string | undefined);
    /**
     * @stability stable
     */
    resetOrderId(): void;
    /**
     * @stability stable
     */
    get orderIdInput(): string | undefined;
    private _os?;
    /**
     * @stability stable
     */
    get os(): string | undefined;
    /**
     * @stability stable
     */
    set os(value: string | undefined);
    /**
     * @stability stable
     */
    resetOs(): void;
    /**
     * @stability stable
     */
    get osInput(): string | undefined;
    private _postinstall?;
    /**
     * @stability stable
     */
    get postinstall(): string | undefined;
    /**
     * @stability stable
     */
    set postinstall(value: string | undefined);
    /**
     * @stability stable
     */
    resetPostinstall(): void;
    /**
     * @stability stable
     */
    get postinstallInput(): string | undefined;
    private _preinstall?;
    /**
     * @stability stable
     */
    get preinstall(): string | undefined;
    /**
     * @stability stable
     */
    set preinstall(value: string | undefined);
    /**
     * @stability stable
     */
    resetPreinstall(): void;
    /**
     * @stability stable
     */
    get preinstallInput(): string | undefined;
    private _privateIp?;
    /**
     * @stability stable
     */
    get privateIp(): string | undefined;
    /**
     * @stability stable
     */
    set privateIp(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrivateIp(): void;
    /**
     * @stability stable
     */
    get privateIpInput(): string | undefined;
    private _productId?;
    /**
     * @stability stable
     */
    get productId(): string | undefined;
    /**
     * @stability stable
     */
    set productId(value: string | undefined);
    /**
     * @stability stable
     */
    resetProductId(): void;
    /**
     * @stability stable
     */
    get productIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get publicIp(): string;
    private _publicKey?;
    /**
     * @stability stable
     */
    get publicKey(): string | undefined;
    /**
     * @stability stable
     */
    set publicKey(value: string | undefined);
    /**
     * @stability stable
     */
    resetPublicKey(): void;
    /**
     * @stability stable
     */
    get publicKeyInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get serverId(): string;
    private _sharetype?;
    /**
     * @stability stable
     */
    get sharetype(): string | undefined;
    /**
     * @stability stable
     */
    set sharetype(value: string | undefined);
    /**
     * @stability stable
     */
    resetSharetype(): void;
    /**
     * @stability stable
     */
    get sharetypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string | undefined;
    /**
     * @stability stable
     */
    set subnetId(value: string | undefined);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _dataVolumes?;
    /**
     * @stability stable
     */
    get dataVolumes(): CceNodeV3DataVolumes[];
    /**
     * @stability stable
     */
    set dataVolumes(value: CceNodeV3DataVolumes[]);
    /**
     * @stability stable
     */
    get dataVolumesInput(): CceNodeV3DataVolumes[] | undefined;
    private _rootVolume?;
    private __rootVolumeOutput;
    /**
     * @stability stable
     */
    get rootVolume(): CceNodeV3RootVolumeOutputReference;
    /**
     * @stability stable
     */
    putRootVolume(value: CceNodeV3RootVolume): void;
    /**
     * @stability stable
     */
    get rootVolumeInput(): CceNodeV3RootVolume | undefined;
    private _taints?;
    /**
     * @stability stable
     */
    get taints(): CceNodeV3Taints[] | undefined;
    /**
     * @stability stable
     */
    set taints(value: CceNodeV3Taints[] | undefined);
    /**
     * @stability stable
     */
    resetTaints(): void;
    /**
     * @stability stable
     */
    get taintsInput(): CceNodeV3Taints[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): CceNodeV3TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CceNodeV3Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CceNodeV3Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
