import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CesAlarmruleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#alarm_action_enabled CesAlarmrule#alarm_action_enabled}.
     *
     * @stability stable
     */
    readonly alarmActionEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#alarm_description CesAlarmrule#alarm_description}.
     *
     * @stability stable
     */
    readonly alarmDescription?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#alarm_enabled CesAlarmrule#alarm_enabled}.
     *
     * @stability stable
     */
    readonly alarmEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#alarm_level CesAlarmrule#alarm_level}.
     *
     * @stability stable
     */
    readonly alarmLevel?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#alarm_name CesAlarmrule#alarm_name}.
     *
     * @stability stable
     */
    readonly alarmName: string;
    /**
     * alarm_actions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#alarm_actions CesAlarmrule#alarm_actions}
     *
     * @stability stable
     */
    readonly alarmActions?: CesAlarmruleAlarmActions[];
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#condition CesAlarmrule#condition}
     *
     * @stability stable
     */
    readonly condition: CesAlarmruleCondition;
    /**
     * insufficientdata_actions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#insufficientdata_actions CesAlarmrule#insufficientdata_actions}
     *
     * @stability stable
     */
    readonly insufficientdataActions?: CesAlarmruleInsufficientdataActions[];
    /**
     * metric block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#metric CesAlarmrule#metric}
     *
     * @stability stable
     */
    readonly metric: CesAlarmruleMetric;
    /**
     * ok_actions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#ok_actions CesAlarmrule#ok_actions}
     *
     * @stability stable
     */
    readonly okActions?: CesAlarmruleOkActions[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#timeouts CesAlarmrule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CesAlarmruleTimeouts;
}
/**
 * @stability stable
 */
export interface CesAlarmruleAlarmActions {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#notification_list CesAlarmrule#notification_list}.
     *
     * @stability stable
     */
    readonly notificationList: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#type CesAlarmrule#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * @stability stable
 */
export interface CesAlarmruleCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#comparison_operator CesAlarmrule#comparison_operator}.
     *
     * @stability stable
     */
    readonly comparisonOperator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#count CesAlarmrule#count}.
     *
     * @stability stable
     */
    readonly count: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#filter CesAlarmrule#filter}.
     *
     * @stability stable
     */
    readonly filter: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#period CesAlarmrule#period}.
     *
     * @stability stable
     */
    readonly period: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#unit CesAlarmrule#unit}.
     *
     * @stability stable
     */
    readonly unit?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#value CesAlarmrule#value}.
     *
     * @stability stable
     */
    readonly value: number;
}
/**
 * @stability stable
 */
export declare class CesAlarmruleConditionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _comparisonOperator?;
    /**
     * @stability stable
     */
    get comparisonOperator(): string;
    /**
     * @stability stable
     */
    set comparisonOperator(value: string);
    /**
     * @stability stable
     */
    get comparisonOperatorInput(): string | undefined;
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): string;
    /**
     * @stability stable
     */
    set filter(value: string);
    /**
     * @stability stable
     */
    get filterInput(): string | undefined;
    private _period?;
    /**
     * @stability stable
     */
    get period(): number;
    /**
     * @stability stable
     */
    set period(value: number);
    /**
     * @stability stable
     */
    get periodInput(): number | undefined;
    private _unit?;
    /**
     * @stability stable
     */
    get unit(): string | undefined;
    /**
     * @stability stable
     */
    set unit(value: string | undefined);
    /**
     * @stability stable
     */
    resetUnit(): void;
    /**
     * @stability stable
     */
    get unitInput(): string | undefined;
    private _value?;
    /**
     * @stability stable
     */
    get value(): number;
    /**
     * @stability stable
     */
    set value(value: number);
    /**
     * @stability stable
     */
    get valueInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface CesAlarmruleInsufficientdataActions {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#notification_list CesAlarmrule#notification_list}.
     *
     * @stability stable
     */
    readonly notificationList: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#type CesAlarmrule#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * @stability stable
 */
export interface CesAlarmruleMetricDimensions {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#name CesAlarmrule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#value CesAlarmrule#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface CesAlarmruleMetric {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#metric_name CesAlarmrule#metric_name}.
     *
     * @stability stable
     */
    readonly metricName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#namespace CesAlarmrule#namespace}.
     *
     * @stability stable
     */
    readonly namespace: string;
    /**
     * dimensions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#dimensions CesAlarmrule#dimensions}
     *
     * @stability stable
     */
    readonly dimensions: CesAlarmruleMetricDimensions[];
}
/**
 * @stability stable
 */
export declare class CesAlarmruleMetricOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _metricName?;
    /**
     * @stability stable
     */
    get metricName(): string;
    /**
     * @stability stable
     */
    set metricName(value: string);
    /**
     * @stability stable
     */
    get metricNameInput(): string | undefined;
    private _namespace?;
    /**
     * @stability stable
     */
    get namespace(): string;
    /**
     * @stability stable
     */
    set namespace(value: string);
    /**
     * @stability stable
     */
    get namespaceInput(): string | undefined;
    private _dimensions?;
    /**
     * @stability stable
     */
    get dimensions(): CesAlarmruleMetricDimensions[];
    /**
     * @stability stable
     */
    set dimensions(value: CesAlarmruleMetricDimensions[]);
    /**
     * @stability stable
     */
    get dimensionsInput(): CesAlarmruleMetricDimensions[] | undefined;
}
/**
 * @stability stable
 */
export interface CesAlarmruleOkActions {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#notification_list CesAlarmrule#notification_list}.
     *
     * @stability stable
     */
    readonly notificationList: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#type CesAlarmrule#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * @stability stable
 */
export interface CesAlarmruleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#create CesAlarmrule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#delete CesAlarmrule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html#update CesAlarmrule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class CesAlarmruleTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html opentelekomcloud_ces_alarmrule}.
 *
 * @stability stable
 */
export declare class CesAlarmrule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ces_alarmrule.html opentelekomcloud_ces_alarmrule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CesAlarmruleConfig);
    private _alarmActionEnabled?;
    /**
     * @stability stable
     */
    get alarmActionEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set alarmActionEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAlarmActionEnabled(): void;
    /**
     * @stability stable
     */
    get alarmActionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _alarmDescription?;
    /**
     * @stability stable
     */
    get alarmDescription(): string | undefined;
    /**
     * @stability stable
     */
    set alarmDescription(value: string | undefined);
    /**
     * @stability stable
     */
    resetAlarmDescription(): void;
    /**
     * @stability stable
     */
    get alarmDescriptionInput(): string | undefined;
    private _alarmEnabled?;
    /**
     * @stability stable
     */
    get alarmEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set alarmEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAlarmEnabled(): void;
    /**
     * @stability stable
     */
    get alarmEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _alarmLevel?;
    /**
     * @stability stable
     */
    get alarmLevel(): number | undefined;
    /**
     * @stability stable
     */
    set alarmLevel(value: number | undefined);
    /**
     * @stability stable
     */
    resetAlarmLevel(): void;
    /**
     * @stability stable
     */
    get alarmLevelInput(): number | undefined;
    private _alarmName?;
    /**
     * @stability stable
     */
    get alarmName(): string;
    /**
     * @stability stable
     */
    set alarmName(value: string);
    /**
     * @stability stable
     */
    get alarmNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get alarmState(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get updateTime(): number;
    private _alarmActions?;
    /**
     * @stability stable
     */
    get alarmActions(): CesAlarmruleAlarmActions[] | undefined;
    /**
     * @stability stable
     */
    set alarmActions(value: CesAlarmruleAlarmActions[] | undefined);
    /**
     * @stability stable
     */
    resetAlarmActions(): void;
    /**
     * @stability stable
     */
    get alarmActionsInput(): CesAlarmruleAlarmActions[] | undefined;
    private _condition?;
    private __conditionOutput;
    /**
     * @stability stable
     */
    get condition(): CesAlarmruleConditionOutputReference;
    /**
     * @stability stable
     */
    putCondition(value: CesAlarmruleCondition): void;
    /**
     * @stability stable
     */
    get conditionInput(): CesAlarmruleCondition | undefined;
    private _insufficientdataActions?;
    /**
     * @stability stable
     */
    get insufficientdataActions(): CesAlarmruleInsufficientdataActions[] | undefined;
    /**
     * @stability stable
     */
    set insufficientdataActions(value: CesAlarmruleInsufficientdataActions[] | undefined);
    /**
     * @stability stable
     */
    resetInsufficientdataActions(): void;
    /**
     * @stability stable
     */
    get insufficientdataActionsInput(): CesAlarmruleInsufficientdataActions[] | undefined;
    private _metric?;
    private __metricOutput;
    /**
     * @stability stable
     */
    get metric(): CesAlarmruleMetricOutputReference;
    /**
     * @stability stable
     */
    putMetric(value: CesAlarmruleMetric): void;
    /**
     * @stability stable
     */
    get metricInput(): CesAlarmruleMetric | undefined;
    private _okActions?;
    /**
     * @stability stable
     */
    get okActions(): CesAlarmruleOkActions[] | undefined;
    /**
     * @stability stable
     */
    set okActions(value: CesAlarmruleOkActions[] | undefined);
    /**
     * @stability stable
     */
    resetOkActions(): void;
    /**
     * @stability stable
     */
    get okActionsInput(): CesAlarmruleOkActions[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): CesAlarmruleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CesAlarmruleTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CesAlarmruleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
