import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeBmsServerV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#admin_pass ComputeBmsServerV2#admin_pass}.
     *
     * @stability stable
     */
    readonly adminPass?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#availability_zone ComputeBmsServerV2#availability_zone}.
     *
     * @stability stable
     */
    readonly availabilityZone: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#flavor_id ComputeBmsServerV2#flavor_id}.
     *
     * @stability stable
     */
    readonly flavorId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#flavor_name ComputeBmsServerV2#flavor_name}.
     *
     * @stability stable
     */
    readonly flavorName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#image_id ComputeBmsServerV2#image_id}.
     *
     * @stability stable
     */
    readonly imageId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#image_name ComputeBmsServerV2#image_name}.
     *
     * @stability stable
     */
    readonly imageName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#key_pair ComputeBmsServerV2#key_pair}.
     *
     * @stability stable
     */
    readonly keyPair?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#metadata ComputeBmsServerV2#metadata}.
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#name ComputeBmsServerV2#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#region ComputeBmsServerV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#security_groups ComputeBmsServerV2#security_groups}.
     *
     * @stability stable
     */
    readonly securityGroups?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#stop_before_destroy ComputeBmsServerV2#stop_before_destroy}.
     *
     * @stability stable
     */
    readonly stopBeforeDestroy?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#tags ComputeBmsServerV2#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#user_data ComputeBmsServerV2#user_data}.
     *
     * @stability stable
     */
    readonly userData?: string;
    /**
     * block_device block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#block_device ComputeBmsServerV2#block_device}
     *
     * @stability stable
     */
    readonly blockDevice?: ComputeBmsServerV2BlockDevice[];
    /**
     * network block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#network ComputeBmsServerV2#network}
     *
     * @stability stable
     */
    readonly network?: ComputeBmsServerV2Network[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#timeouts ComputeBmsServerV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeBmsServerV2Timeouts;
}
/**
 * @stability stable
 */
export interface ComputeBmsServerV2BlockDevice {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#boot_index ComputeBmsServerV2#boot_index}.
     *
     * @stability stable
     */
    readonly bootIndex?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#delete_on_termination ComputeBmsServerV2#delete_on_termination}.
     *
     * @stability stable
     */
    readonly deleteOnTermination?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#destination_type ComputeBmsServerV2#destination_type}.
     *
     * @stability stable
     */
    readonly destinationType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#device_name ComputeBmsServerV2#device_name}.
     *
     * @stability stable
     */
    readonly deviceName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#guest_format ComputeBmsServerV2#guest_format}.
     *
     * @stability stable
     */
    readonly guestFormat?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#source_type ComputeBmsServerV2#source_type}.
     *
     * @stability stable
     */
    readonly sourceType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#uuid ComputeBmsServerV2#uuid}.
     *
     * @stability stable
     */
    readonly uuid?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#volume_size ComputeBmsServerV2#volume_size}.
     *
     * @stability stable
     */
    readonly volumeSize?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#volume_type ComputeBmsServerV2#volume_type}.
     *
     * @stability stable
     */
    readonly volumeType?: string;
}
/**
 * @stability stable
 */
export interface ComputeBmsServerV2Network {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#access_network ComputeBmsServerV2#access_network}.
     *
     * @stability stable
     */
    readonly accessNetwork?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#fixed_ip_v4 ComputeBmsServerV2#fixed_ip_v4}.
     *
     * @stability stable
     */
    readonly fixedIpV4?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#fixed_ip_v6 ComputeBmsServerV2#fixed_ip_v6}.
     *
     * @stability stable
     */
    readonly fixedIpV6?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#name ComputeBmsServerV2#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#port ComputeBmsServerV2#port}.
     *
     * @stability stable
     */
    readonly port?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#uuid ComputeBmsServerV2#uuid}.
     *
     * @stability stable
     */
    readonly uuid?: string;
}
/**
 * @stability stable
 */
export interface ComputeBmsServerV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#create ComputeBmsServerV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#delete ComputeBmsServerV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html#update ComputeBmsServerV2#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class ComputeBmsServerV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html opentelekomcloud_compute_bms_server_v2}.
 *
 * @stability stable
 */
export declare class ComputeBmsServerV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_bms_server_v2.html opentelekomcloud_compute_bms_server_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeBmsServerV2Config);
    /**
     * @stability stable
     */
    get accessIpV4(): string;
    /**
     * @stability stable
     */
    get accessIpV6(): string;
    private _adminPass?;
    /**
     * @stability stable
     */
    get adminPass(): string | undefined;
    /**
     * @stability stable
     */
    set adminPass(value: string | undefined);
    /**
     * @stability stable
     */
    resetAdminPass(): void;
    /**
     * @stability stable
     */
    get adminPassInput(): string | undefined;
    private _availabilityZone?;
    /**
     * @stability stable
     */
    get availabilityZone(): string;
    /**
     * @stability stable
     */
    set availabilityZone(value: string);
    /**
     * @stability stable
     */
    get availabilityZoneInput(): string | undefined;
    /**
     * @stability stable
     */
    get configDrive(): any;
    private _flavorId?;
    /**
     * @stability stable
     */
    get flavorId(): string | undefined;
    /**
     * @stability stable
     */
    set flavorId(value: string | undefined);
    /**
     * @stability stable
     */
    resetFlavorId(): void;
    /**
     * @stability stable
     */
    get flavorIdInput(): string | undefined;
    private _flavorName?;
    /**
     * @stability stable
     */
    get flavorName(): string | undefined;
    /**
     * @stability stable
     */
    set flavorName(value: string | undefined);
    /**
     * @stability stable
     */
    resetFlavorName(): void;
    /**
     * @stability stable
     */
    get flavorNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get hostId(): string;
    /**
     * @stability stable
     */
    get hostStatus(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _imageId?;
    /**
     * @stability stable
     */
    get imageId(): string | undefined;
    /**
     * @stability stable
     */
    set imageId(value: string | undefined);
    /**
     * @stability stable
     */
    resetImageId(): void;
    /**
     * @stability stable
     */
    get imageIdInput(): string | undefined;
    private _imageName?;
    /**
     * @stability stable
     */
    get imageName(): string | undefined;
    /**
     * @stability stable
     */
    set imageName(value: string | undefined);
    /**
     * @stability stable
     */
    resetImageName(): void;
    /**
     * @stability stable
     */
    get imageNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get kernelId(): string;
    private _keyPair?;
    /**
     * @stability stable
     */
    get keyPair(): string | undefined;
    /**
     * @stability stable
     */
    set keyPair(value: string | undefined);
    /**
     * @stability stable
     */
    resetKeyPair(): void;
    /**
     * @stability stable
     */
    get keyPairInput(): string | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _securityGroups?;
    /**
     * @stability stable
     */
    get securityGroups(): string[] | undefined;
    /**
     * @stability stable
     */
    set securityGroups(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetSecurityGroups(): void;
    /**
     * @stability stable
     */
    get securityGroupsInput(): string[] | undefined;
    private _stopBeforeDestroy?;
    /**
     * @stability stable
     */
    get stopBeforeDestroy(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set stopBeforeDestroy(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetStopBeforeDestroy(): void;
    /**
     * @stability stable
     */
    get stopBeforeDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get tenantId(): string;
    private _userData?;
    /**
     * @stability stable
     */
    get userData(): string | undefined;
    /**
     * @stability stable
     */
    set userData(value: string | undefined);
    /**
     * @stability stable
     */
    resetUserData(): void;
    /**
     * @stability stable
     */
    get userDataInput(): string | undefined;
    /**
     * @stability stable
     */
    get userId(): string;
    private _blockDevice?;
    /**
     * @stability stable
     */
    get blockDevice(): ComputeBmsServerV2BlockDevice[] | undefined;
    /**
     * @stability stable
     */
    set blockDevice(value: ComputeBmsServerV2BlockDevice[] | undefined);
    /**
     * @stability stable
     */
    resetBlockDevice(): void;
    /**
     * @stability stable
     */
    get blockDeviceInput(): ComputeBmsServerV2BlockDevice[] | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): ComputeBmsServerV2Network[] | undefined;
    /**
     * @stability stable
     */
    set network(value: ComputeBmsServerV2Network[] | undefined);
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): ComputeBmsServerV2Network[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ComputeBmsServerV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeBmsServerV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeBmsServerV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
