import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeFloatingipAssociateV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_floatingip_associate_v2.html#fixed_ip ComputeFloatingipAssociateV2#fixed_ip}.
     *
     * @stability stable
     */
    readonly fixedIp?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_floatingip_associate_v2.html#floating_ip ComputeFloatingipAssociateV2#floating_ip}.
     *
     * @stability stable
     */
    readonly floatingIp: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_floatingip_associate_v2.html#instance_id ComputeFloatingipAssociateV2#instance_id}.
     *
     * @stability stable
     */
    readonly instanceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_floatingip_associate_v2.html#region ComputeFloatingipAssociateV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_floatingip_associate_v2.html opentelekomcloud_compute_floatingip_associate_v2}.
 *
 * @stability stable
 */
export declare class ComputeFloatingipAssociateV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_floatingip_associate_v2.html opentelekomcloud_compute_floatingip_associate_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeFloatingipAssociateV2Config);
    private _fixedIp?;
    /**
     * @stability stable
     */
    get fixedIp(): string | undefined;
    /**
     * @stability stable
     */
    set fixedIp(value: string | undefined);
    /**
     * @stability stable
     */
    resetFixedIp(): void;
    /**
     * @stability stable
     */
    get fixedIpInput(): string | undefined;
    private _floatingIp?;
    /**
     * @stability stable
     */
    get floatingIp(): string;
    /**
     * @stability stable
     */
    set floatingIp(value: string);
    /**
     * @stability stable
     */
    get floatingIpInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _instanceId?;
    /**
     * @stability stable
     */
    get instanceId(): string;
    /**
     * @stability stable
     */
    set instanceId(value: string);
    /**
     * @stability stable
     */
    get instanceIdInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
