import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeFloatingipV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_floatingip_v2.html#pool ComputeFloatingipV2#pool}.
     *
     * @stability stable
     */
    readonly pool?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_floatingip_v2.html#region ComputeFloatingipV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_floatingip_v2.html opentelekomcloud_compute_floatingip_v2}.
 *
 * @stability stable
 */
export declare class ComputeFloatingipV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_floatingip_v2.html opentelekomcloud_compute_floatingip_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: ComputeFloatingipV2Config);
    /**
     * @stability stable
     */
    get address(): string;
    /**
     * @stability stable
     */
    get fixedIp(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get instanceId(): string;
    private _pool?;
    /**
     * @stability stable
     */
    get pool(): string | undefined;
    /**
     * @stability stable
     */
    set pool(value: string | undefined);
    /**
     * @stability stable
     */
    resetPool(): void;
    /**
     * @stability stable
     */
    get poolInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
