import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeInstanceV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#access_ip_v4 ComputeInstanceV2#access_ip_v4}.
     *
     * @stability stable
     */
    readonly accessIpV4?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#access_ip_v6 ComputeInstanceV2#access_ip_v6}.
     *
     * @stability stable
     */
    readonly accessIpV6?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#admin_pass ComputeInstanceV2#admin_pass}.
     *
     * @stability stable
     */
    readonly adminPass?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#auto_recovery ComputeInstanceV2#auto_recovery}.
     *
     * @stability stable
     */
    readonly autoRecovery?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#availability_zone ComputeInstanceV2#availability_zone}.
     *
     * @stability stable
     */
    readonly availabilityZone?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#config_drive ComputeInstanceV2#config_drive}.
     *
     * @stability stable
     */
    readonly configDrive?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#flavor_id ComputeInstanceV2#flavor_id}.
     *
     * @stability stable
     */
    readonly flavorId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#flavor_name ComputeInstanceV2#flavor_name}.
     *
     * @stability stable
     */
    readonly flavorName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#image_id ComputeInstanceV2#image_id}.
     *
     * @stability stable
     */
    readonly imageId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#image_name ComputeInstanceV2#image_name}.
     *
     * @stability stable
     */
    readonly imageName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#key_pair ComputeInstanceV2#key_pair}.
     *
     * @stability stable
     */
    readonly keyPair?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#metadata ComputeInstanceV2#metadata}.
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#name ComputeInstanceV2#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#power_state ComputeInstanceV2#power_state}.
     *
     * @stability stable
     */
    readonly powerState?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#region ComputeInstanceV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#security_groups ComputeInstanceV2#security_groups}.
     *
     * @stability stable
     */
    readonly securityGroups?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#stop_before_destroy ComputeInstanceV2#stop_before_destroy}.
     *
     * @stability stable
     */
    readonly stopBeforeDestroy?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#tags ComputeInstanceV2#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#user_data ComputeInstanceV2#user_data}.
     *
     * @stability stable
     */
    readonly userData?: string;
    /**
     * block_device block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#block_device ComputeInstanceV2#block_device}
     *
     * @stability stable
     */
    readonly blockDevice?: ComputeInstanceV2BlockDevice[];
    /**
     * network block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#network ComputeInstanceV2#network}
     *
     * @stability stable
     */
    readonly network?: ComputeInstanceV2Network[];
    /**
     * scheduler_hints block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#scheduler_hints ComputeInstanceV2#scheduler_hints}
     *
     * @stability stable
     */
    readonly schedulerHints?: ComputeInstanceV2SchedulerHints[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#timeouts ComputeInstanceV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeInstanceV2Timeouts;
}
/**
 * @stability stable
 */
export declare class ComputeInstanceV2VolumeAttached extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): string;
}
/**
 * @stability stable
 */
export interface ComputeInstanceV2BlockDevice {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#boot_index ComputeInstanceV2#boot_index}.
     *
     * @stability stable
     */
    readonly bootIndex?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#delete_on_termination ComputeInstanceV2#delete_on_termination}.
     *
     * @stability stable
     */
    readonly deleteOnTermination?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#destination_type ComputeInstanceV2#destination_type}.
     *
     * @stability stable
     */
    readonly destinationType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#device_name ComputeInstanceV2#device_name}.
     *
     * @stability stable
     */
    readonly deviceName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#guest_format ComputeInstanceV2#guest_format}.
     *
     * @stability stable
     */
    readonly guestFormat?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#source_type ComputeInstanceV2#source_type}.
     *
     * @stability stable
     */
    readonly sourceType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#uuid ComputeInstanceV2#uuid}.
     *
     * @stability stable
     */
    readonly uuid?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#volume_size ComputeInstanceV2#volume_size}.
     *
     * @stability stable
     */
    readonly volumeSize?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#volume_type ComputeInstanceV2#volume_type}.
     *
     * @stability stable
     */
    readonly volumeType?: string;
}
/**
 * @stability stable
 */
export interface ComputeInstanceV2Network {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#access_network ComputeInstanceV2#access_network}.
     *
     * @stability stable
     */
    readonly accessNetwork?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#fixed_ip_v4 ComputeInstanceV2#fixed_ip_v4}.
     *
     * @stability stable
     */
    readonly fixedIpV4?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#fixed_ip_v6 ComputeInstanceV2#fixed_ip_v6}.
     *
     * @stability stable
     */
    readonly fixedIpV6?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#name ComputeInstanceV2#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#port ComputeInstanceV2#port}.
     *
     * @stability stable
     */
    readonly port?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#uuid ComputeInstanceV2#uuid}.
     *
     * @stability stable
     */
    readonly uuid?: string;
}
/**
 * @stability stable
 */
export interface ComputeInstanceV2SchedulerHints {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#build_near_host_ip ComputeInstanceV2#build_near_host_ip}.
     *
     * @stability stable
     */
    readonly buildNearHostIp?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#deh_id ComputeInstanceV2#deh_id}.
     *
     * @stability stable
     */
    readonly dehId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#different_host ComputeInstanceV2#different_host}.
     *
     * @stability stable
     */
    readonly differentHost?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#group ComputeInstanceV2#group}.
     *
     * @stability stable
     */
    readonly group?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#query ComputeInstanceV2#query}.
     *
     * @stability stable
     */
    readonly query?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#same_host ComputeInstanceV2#same_host}.
     *
     * @stability stable
     */
    readonly sameHost?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#target_cell ComputeInstanceV2#target_cell}.
     *
     * @stability stable
     */
    readonly targetCell?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#tenancy ComputeInstanceV2#tenancy}.
     *
     * @stability stable
     */
    readonly tenancy?: string;
}
/**
 * @stability stable
 */
export interface ComputeInstanceV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#create ComputeInstanceV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#delete ComputeInstanceV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html#update ComputeInstanceV2#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class ComputeInstanceV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html opentelekomcloud_compute_instance_v2}.
 *
 * @stability stable
 */
export declare class ComputeInstanceV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_instance_v2.html opentelekomcloud_compute_instance_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeInstanceV2Config);
    private _accessIpV4?;
    /**
     * @stability stable
     */
    get accessIpV4(): string | undefined;
    /**
     * @stability stable
     */
    set accessIpV4(value: string | undefined);
    /**
     * @stability stable
     */
    resetAccessIpV4(): void;
    /**
     * @stability stable
     */
    get accessIpV4Input(): string | undefined;
    private _accessIpV6?;
    /**
     * @stability stable
     */
    get accessIpV6(): string | undefined;
    /**
     * @stability stable
     */
    set accessIpV6(value: string | undefined);
    /**
     * @stability stable
     */
    resetAccessIpV6(): void;
    /**
     * @stability stable
     */
    get accessIpV6Input(): string | undefined;
    private _adminPass?;
    /**
     * @stability stable
     */
    get adminPass(): string | undefined;
    /**
     * @stability stable
     */
    set adminPass(value: string | undefined);
    /**
     * @stability stable
     */
    resetAdminPass(): void;
    /**
     * @stability stable
     */
    get adminPassInput(): string | undefined;
    /**
     * @stability stable
     */
    allMetadata(key: string): string;
    private _autoRecovery?;
    /**
     * @stability stable
     */
    get autoRecovery(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set autoRecovery(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAutoRecovery(): void;
    /**
     * @stability stable
     */
    get autoRecoveryInput(): boolean | cdktf.IResolvable | undefined;
    private _availabilityZone?;
    /**
     * @stability stable
     */
    get availabilityZone(): string | undefined;
    /**
     * @stability stable
     */
    set availabilityZone(value: string | undefined);
    /**
     * @stability stable
     */
    resetAvailabilityZone(): void;
    /**
     * @stability stable
     */
    get availabilityZoneInput(): string | undefined;
    private _configDrive?;
    /**
     * @stability stable
     */
    get configDrive(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set configDrive(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetConfigDrive(): void;
    /**
     * @stability stable
     */
    get configDriveInput(): boolean | cdktf.IResolvable | undefined;
    private _flavorId?;
    /**
     * @stability stable
     */
    get flavorId(): string | undefined;
    /**
     * @stability stable
     */
    set flavorId(value: string | undefined);
    /**
     * @stability stable
     */
    resetFlavorId(): void;
    /**
     * @stability stable
     */
    get flavorIdInput(): string | undefined;
    private _flavorName?;
    /**
     * @stability stable
     */
    get flavorName(): string | undefined;
    /**
     * @stability stable
     */
    set flavorName(value: string | undefined);
    /**
     * @stability stable
     */
    resetFlavorName(): void;
    /**
     * @stability stable
     */
    get flavorNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _imageId?;
    /**
     * @stability stable
     */
    get imageId(): string | undefined;
    /**
     * @stability stable
     */
    set imageId(value: string | undefined);
    /**
     * @stability stable
     */
    resetImageId(): void;
    /**
     * @stability stable
     */
    get imageIdInput(): string | undefined;
    private _imageName?;
    /**
     * @stability stable
     */
    get imageName(): string | undefined;
    /**
     * @stability stable
     */
    set imageName(value: string | undefined);
    /**
     * @stability stable
     */
    resetImageName(): void;
    /**
     * @stability stable
     */
    get imageNameInput(): string | undefined;
    private _keyPair?;
    /**
     * @stability stable
     */
    get keyPair(): string | undefined;
    /**
     * @stability stable
     */
    set keyPair(value: string | undefined);
    /**
     * @stability stable
     */
    resetKeyPair(): void;
    /**
     * @stability stable
     */
    get keyPairInput(): string | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _powerState?;
    /**
     * @stability stable
     */
    get powerState(): string | undefined;
    /**
     * @stability stable
     */
    set powerState(value: string | undefined);
    /**
     * @stability stable
     */
    resetPowerState(): void;
    /**
     * @stability stable
     */
    get powerStateInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _securityGroups?;
    /**
     * @stability stable
     */
    get securityGroups(): string[] | undefined;
    /**
     * @stability stable
     */
    set securityGroups(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetSecurityGroups(): void;
    /**
     * @stability stable
     */
    get securityGroupsInput(): string[] | undefined;
    private _stopBeforeDestroy?;
    /**
     * @stability stable
     */
    get stopBeforeDestroy(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set stopBeforeDestroy(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetStopBeforeDestroy(): void;
    /**
     * @stability stable
     */
    get stopBeforeDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _userData?;
    /**
     * @stability stable
     */
    get userData(): string | undefined;
    /**
     * @stability stable
     */
    set userData(value: string | undefined);
    /**
     * @stability stable
     */
    resetUserData(): void;
    /**
     * @stability stable
     */
    get userDataInput(): string | undefined;
    /**
     * @stability stable
     */
    volumeAttached(index: string): ComputeInstanceV2VolumeAttached;
    private _blockDevice?;
    /**
     * @stability stable
     */
    get blockDevice(): ComputeInstanceV2BlockDevice[] | undefined;
    /**
     * @stability stable
     */
    set blockDevice(value: ComputeInstanceV2BlockDevice[] | undefined);
    /**
     * @stability stable
     */
    resetBlockDevice(): void;
    /**
     * @stability stable
     */
    get blockDeviceInput(): ComputeInstanceV2BlockDevice[] | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): ComputeInstanceV2Network[] | undefined;
    /**
     * @stability stable
     */
    set network(value: ComputeInstanceV2Network[] | undefined);
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): ComputeInstanceV2Network[] | undefined;
    private _schedulerHints?;
    /**
     * @stability stable
     */
    get schedulerHints(): ComputeInstanceV2SchedulerHints[] | undefined;
    /**
     * @stability stable
     */
    set schedulerHints(value: ComputeInstanceV2SchedulerHints[] | undefined);
    /**
     * @stability stable
     */
    resetSchedulerHints(): void;
    /**
     * @stability stable
     */
    get schedulerHintsInput(): ComputeInstanceV2SchedulerHints[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ComputeInstanceV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeInstanceV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeInstanceV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
