import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeKeypairV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_keypair_v2.html#name ComputeKeypairV2#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_keypair_v2.html#public_key ComputeKeypairV2#public_key}.
     *
     * @stability stable
     */
    readonly publicKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_keypair_v2.html#region ComputeKeypairV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_keypair_v2.html#value_specs ComputeKeypairV2#value_specs}.
     *
     * @stability stable
     */
    readonly valueSpecs?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_keypair_v2.html opentelekomcloud_compute_keypair_v2}.
 *
 * @stability stable
 */
export declare class ComputeKeypairV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_keypair_v2.html opentelekomcloud_compute_keypair_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeKeypairV2Config);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get privateKey(): string;
    private _publicKey?;
    /**
     * @stability stable
     */
    get publicKey(): string | undefined;
    /**
     * @stability stable
     */
    set publicKey(value: string | undefined);
    /**
     * @stability stable
     */
    resetPublicKey(): void;
    /**
     * @stability stable
     */
    get publicKeyInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get shared(): any;
    private _valueSpecs?;
    /**
     * @stability stable
     */
    get valueSpecs(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set valueSpecs(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetValueSpecs(): void;
    /**
     * @stability stable
     */
    get valueSpecsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
