import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeSecgroupV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2.html#description ComputeSecgroupV2#description}.
     *
     * @stability stable
     */
    readonly description: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2.html#name ComputeSecgroupV2#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2.html#region ComputeSecgroupV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2.html#rule ComputeSecgroupV2#rule}
     *
     * @stability stable
     */
    readonly rule?: ComputeSecgroupV2Rule[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2.html#timeouts ComputeSecgroupV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeSecgroupV2Timeouts;
}
/**
 * @stability stable
 */
export interface ComputeSecgroupV2Rule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2.html#cidr ComputeSecgroupV2#cidr}.
     *
     * @stability stable
     */
    readonly cidr?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2.html#from_group_id ComputeSecgroupV2#from_group_id}.
     *
     * @stability stable
     */
    readonly fromGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2.html#from_port ComputeSecgroupV2#from_port}.
     *
     * @stability stable
     */
    readonly fromPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2.html#ip_protocol ComputeSecgroupV2#ip_protocol}.
     *
     * @stability stable
     */
    readonly ipProtocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2.html#self ComputeSecgroupV2#self}.
     *
     * @stability stable
     */
    readonly selfAttribute?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2.html#to_port ComputeSecgroupV2#to_port}.
     *
     * @stability stable
     */
    readonly toPort: number;
}
/**
 * @stability stable
 */
export interface ComputeSecgroupV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2.html#delete ComputeSecgroupV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class ComputeSecgroupV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2.html opentelekomcloud_compute_secgroup_v2}.
 *
 * @stability stable
 */
export declare class ComputeSecgroupV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_secgroup_v2.html opentelekomcloud_compute_secgroup_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeSecgroupV2Config);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _rule?;
    /**
     * @stability stable
     */
    get rule(): ComputeSecgroupV2Rule[] | undefined;
    /**
     * @stability stable
     */
    set rule(value: ComputeSecgroupV2Rule[] | undefined);
    /**
     * @stability stable
     */
    resetRule(): void;
    /**
     * @stability stable
     */
    get ruleInput(): ComputeSecgroupV2Rule[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ComputeSecgroupV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeSecgroupV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeSecgroupV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
