import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeVolumeAttachV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_volume_attach_v2.html#device ComputeVolumeAttachV2#device}.
     *
     * @stability stable
     */
    readonly device?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_volume_attach_v2.html#instance_id ComputeVolumeAttachV2#instance_id}.
     *
     * @stability stable
     */
    readonly instanceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_volume_attach_v2.html#region ComputeVolumeAttachV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_volume_attach_v2.html#volume_id ComputeVolumeAttachV2#volume_id}.
     *
     * @stability stable
     */
    readonly volumeId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_volume_attach_v2.html#timeouts ComputeVolumeAttachV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeVolumeAttachV2Timeouts;
}
/**
 * @stability stable
 */
export interface ComputeVolumeAttachV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_volume_attach_v2.html#create ComputeVolumeAttachV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_volume_attach_v2.html#delete ComputeVolumeAttachV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class ComputeVolumeAttachV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_volume_attach_v2.html opentelekomcloud_compute_volume_attach_v2}.
 *
 * @stability stable
 */
export declare class ComputeVolumeAttachV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/compute_volume_attach_v2.html opentelekomcloud_compute_volume_attach_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeVolumeAttachV2Config);
    private _device?;
    /**
     * @stability stable
     */
    get device(): string | undefined;
    /**
     * @stability stable
     */
    set device(value: string | undefined);
    /**
     * @stability stable
     */
    resetDevice(): void;
    /**
     * @stability stable
     */
    get deviceInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _instanceId?;
    /**
     * @stability stable
     */
    get instanceId(): string;
    /**
     * @stability stable
     */
    set instanceId(value: string);
    /**
     * @stability stable
     */
    get instanceIdInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _volumeId?;
    /**
     * @stability stable
     */
    get volumeId(): string;
    /**
     * @stability stable
     */
    set volumeId(value: string);
    /**
     * @stability stable
     */
    get volumeIdInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ComputeVolumeAttachV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeVolumeAttachV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeVolumeAttachV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
