import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CsbsBackupPolicyV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#common CsbsBackupPolicyV1#common}.
     *
     * @stability stable
     */
    readonly common?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#description CsbsBackupPolicyV1#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#name CsbsBackupPolicyV1#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#provider_id CsbsBackupPolicyV1#provider_id}.
     *
     * @stability stable
     */
    readonly providerId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#region CsbsBackupPolicyV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * resource block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#resource CsbsBackupPolicyV1#resource}
     *
     * @stability stable
     */
    readonly resource: CsbsBackupPolicyV1Resource[];
    /**
     * scheduled_operation block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#scheduled_operation CsbsBackupPolicyV1#scheduled_operation}
     *
     * @stability stable
     */
    readonly scheduledOperation: CsbsBackupPolicyV1ScheduledOperation;
    /**
     * tags block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#tags CsbsBackupPolicyV1#tags}
     *
     * @stability stable
     */
    readonly tags?: CsbsBackupPolicyV1Tags[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#timeouts CsbsBackupPolicyV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CsbsBackupPolicyV1Timeouts;
}
/**
 * @stability stable
 */
export interface CsbsBackupPolicyV1Resource {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#id CsbsBackupPolicyV1#id}.
     *
     * @stability stable
     */
    readonly id: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#name CsbsBackupPolicyV1#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#type CsbsBackupPolicyV1#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * @stability stable
 */
export interface CsbsBackupPolicyV1ScheduledOperation {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#day_backups CsbsBackupPolicyV1#day_backups}.
     *
     * @stability stable
     */
    readonly dayBackups?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#description CsbsBackupPolicyV1#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#enabled CsbsBackupPolicyV1#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#max_backups CsbsBackupPolicyV1#max_backups}.
     *
     * @stability stable
     */
    readonly maxBackups?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#month_backups CsbsBackupPolicyV1#month_backups}.
     *
     * @stability stable
     */
    readonly monthBackups?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#name CsbsBackupPolicyV1#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#operation_type CsbsBackupPolicyV1#operation_type}.
     *
     * @stability stable
     */
    readonly operationType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#permanent CsbsBackupPolicyV1#permanent}.
     *
     * @stability stable
     */
    readonly permanent?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#retention_duration_days CsbsBackupPolicyV1#retention_duration_days}.
     *
     * @stability stable
     */
    readonly retentionDurationDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#timezone CsbsBackupPolicyV1#timezone}.
     *
     * @stability stable
     */
    readonly timezone?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#trigger_pattern CsbsBackupPolicyV1#trigger_pattern}.
     *
     * @stability stable
     */
    readonly triggerPattern: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#week_backups CsbsBackupPolicyV1#week_backups}.
     *
     * @stability stable
     */
    readonly weekBackups?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#year_backups CsbsBackupPolicyV1#year_backups}.
     *
     * @stability stable
     */
    readonly yearBackups?: number;
}
/**
 * @stability stable
 */
export declare class CsbsBackupPolicyV1ScheduledOperationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _dayBackups?;
    /**
     * @stability stable
     */
    get dayBackups(): number | undefined;
    /**
     * @stability stable
     */
    set dayBackups(value: number | undefined);
    /**
     * @stability stable
     */
    resetDayBackups(): void;
    /**
     * @stability stable
     */
    get dayBackupsInput(): number | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _maxBackups?;
    /**
     * @stability stable
     */
    get maxBackups(): number | undefined;
    /**
     * @stability stable
     */
    set maxBackups(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxBackups(): void;
    /**
     * @stability stable
     */
    get maxBackupsInput(): number | undefined;
    private _monthBackups?;
    /**
     * @stability stable
     */
    get monthBackups(): number | undefined;
    /**
     * @stability stable
     */
    set monthBackups(value: number | undefined);
    /**
     * @stability stable
     */
    resetMonthBackups(): void;
    /**
     * @stability stable
     */
    get monthBackupsInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operationType?;
    /**
     * @stability stable
     */
    get operationType(): string;
    /**
     * @stability stable
     */
    set operationType(value: string);
    /**
     * @stability stable
     */
    get operationTypeInput(): string | undefined;
    private _permanent?;
    /**
     * @stability stable
     */
    get permanent(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set permanent(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetPermanent(): void;
    /**
     * @stability stable
     */
    get permanentInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionDurationDays?;
    /**
     * @stability stable
     */
    get retentionDurationDays(): number | undefined;
    /**
     * @stability stable
     */
    set retentionDurationDays(value: number | undefined);
    /**
     * @stability stable
     */
    resetRetentionDurationDays(): void;
    /**
     * @stability stable
     */
    get retentionDurationDaysInput(): number | undefined;
    private _timezone?;
    /**
     * @stability stable
     */
    get timezone(): string | undefined;
    /**
     * @stability stable
     */
    set timezone(value: string | undefined);
    /**
     * @stability stable
     */
    resetTimezone(): void;
    /**
     * @stability stable
     */
    get timezoneInput(): string | undefined;
    private _triggerPattern?;
    /**
     * @stability stable
     */
    get triggerPattern(): string;
    /**
     * @stability stable
     */
    set triggerPattern(value: string);
    /**
     * @stability stable
     */
    get triggerPatternInput(): string | undefined;
    private _weekBackups?;
    /**
     * @stability stable
     */
    get weekBackups(): number | undefined;
    /**
     * @stability stable
     */
    set weekBackups(value: number | undefined);
    /**
     * @stability stable
     */
    resetWeekBackups(): void;
    /**
     * @stability stable
     */
    get weekBackupsInput(): number | undefined;
    private _yearBackups?;
    /**
     * @stability stable
     */
    get yearBackups(): number | undefined;
    /**
     * @stability stable
     */
    set yearBackups(value: number | undefined);
    /**
     * @stability stable
     */
    resetYearBackups(): void;
    /**
     * @stability stable
     */
    get yearBackupsInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface CsbsBackupPolicyV1Tags {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#key CsbsBackupPolicyV1#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#value CsbsBackupPolicyV1#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface CsbsBackupPolicyV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#create CsbsBackupPolicyV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html#delete CsbsBackupPolicyV1#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class CsbsBackupPolicyV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html opentelekomcloud_csbs_backup_policy_v1}.
 *
 * @stability stable
 */
export declare class CsbsBackupPolicyV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_policy_v1.html opentelekomcloud_csbs_backup_policy_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CsbsBackupPolicyV1Config);
    private _common?;
    /**
     * @stability stable
     */
    get common(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set common(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetCommon(): void;
    /**
     * @stability stable
     */
    get commonInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get createdAt(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _providerId?;
    /**
     * @stability stable
     */
    get providerId(): string | undefined;
    /**
     * @stability stable
     */
    set providerId(value: string | undefined);
    /**
     * @stability stable
     */
    resetProviderId(): void;
    /**
     * @stability stable
     */
    get providerIdInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    private _resource?;
    /**
     * @stability stable
     */
    get resource(): CsbsBackupPolicyV1Resource[];
    /**
     * @stability stable
     */
    set resource(value: CsbsBackupPolicyV1Resource[]);
    /**
     * @stability stable
     */
    get resourceInput(): CsbsBackupPolicyV1Resource[] | undefined;
    private _scheduledOperation?;
    private __scheduledOperationOutput;
    /**
     * @stability stable
     */
    get scheduledOperation(): CsbsBackupPolicyV1ScheduledOperationOutputReference;
    /**
     * @stability stable
     */
    putScheduledOperation(value: CsbsBackupPolicyV1ScheduledOperation): void;
    /**
     * @stability stable
     */
    get scheduledOperationInput(): CsbsBackupPolicyV1ScheduledOperation | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): CsbsBackupPolicyV1Tags[] | undefined;
    /**
     * @stability stable
     */
    set tags(value: CsbsBackupPolicyV1Tags[] | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): CsbsBackupPolicyV1Tags[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): CsbsBackupPolicyV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CsbsBackupPolicyV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CsbsBackupPolicyV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
