import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CsbsBackupV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1.html#backup_name CsbsBackupV1#backup_name}.
     *
     * @stability stable
     */
    readonly backupName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1.html#description CsbsBackupV1#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1.html#region CsbsBackupV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1.html#resource_id CsbsBackupV1#resource_id}.
     *
     * @stability stable
     */
    readonly resourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1.html#resource_type CsbsBackupV1#resource_type}.
     *
     * @stability stable
     */
    readonly resourceType?: string;
    /**
     * tags block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1.html#tags CsbsBackupV1#tags}
     *
     * @stability stable
     */
    readonly tags?: CsbsBackupV1Tags[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1.html#timeouts CsbsBackupV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CsbsBackupV1Timeouts;
}
/**
 * @stability stable
 */
export declare class CsbsBackupV1VmMetadata extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get cloudServiceType(): string;
    /**
     * @stability stable
     */
    get disk(): number;
    /**
     * @stability stable
     */
    get eip(): string;
    /**
     * @stability stable
     */
    get imageType(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get privateIp(): string;
    /**
     * @stability stable
     */
    get ram(): number;
    /**
     * @stability stable
     */
    get vcpus(): number;
}
/**
 * @stability stable
 */
export declare class CsbsBackupV1VolumeBackups extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get averageSpeed(): number;
    /**
     * @stability stable
     */
    get bootable(): any;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get imageType(): string;
    /**
     * @stability stable
     */
    get incremental(): any;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get size(): number;
    /**
     * @stability stable
     */
    get snapshotId(): string;
    /**
     * @stability stable
     */
    get sourceVolumeId(): string;
    /**
     * @stability stable
     */
    get sourceVolumeName(): string;
    /**
     * @stability stable
     */
    get sourceVolumeSize(): number;
    /**
     * @stability stable
     */
    get spaceSavingRatio(): number;
    /**
     * @stability stable
     */
    get status(): string;
}
/**
 * @stability stable
 */
export interface CsbsBackupV1Tags {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1.html#key CsbsBackupV1#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1.html#value CsbsBackupV1#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface CsbsBackupV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1.html#create CsbsBackupV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1.html#delete CsbsBackupV1#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class CsbsBackupV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1.html opentelekomcloud_csbs_backup_v1}.
 *
 * @stability stable
 */
export declare class CsbsBackupV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/csbs_backup_v1.html opentelekomcloud_csbs_backup_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CsbsBackupV1Config);
    private _backupName?;
    /**
     * @stability stable
     */
    get backupName(): string | undefined;
    /**
     * @stability stable
     */
    set backupName(value: string | undefined);
    /**
     * @stability stable
     */
    resetBackupName(): void;
    /**
     * @stability stable
     */
    get backupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get backupRecordId(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _resourceId?;
    /**
     * @stability stable
     */
    get resourceId(): string;
    /**
     * @stability stable
     */
    set resourceId(value: string);
    /**
     * @stability stable
     */
    get resourceIdInput(): string | undefined;
    private _resourceType?;
    /**
     * @stability stable
     */
    get resourceType(): string | undefined;
    /**
     * @stability stable
     */
    set resourceType(value: string | undefined);
    /**
     * @stability stable
     */
    resetResourceType(): void;
    /**
     * @stability stable
     */
    get resourceTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    vmMetadata(index: string): CsbsBackupV1VmMetadata;
    /**
     * @stability stable
     */
    volumeBackups(index: string): CsbsBackupV1VolumeBackups;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): CsbsBackupV1Tags[] | undefined;
    /**
     * @stability stable
     */
    set tags(value: CsbsBackupV1Tags[] | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): CsbsBackupV1Tags[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): CsbsBackupV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CsbsBackupV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CsbsBackupV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
