import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CssClusterV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html#admin_pass CssClusterV1#admin_pass}.
     *
     * @stability stable
     */
    readonly adminPass?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html#enable_authority CssClusterV1#enable_authority}.
     *
     * @stability stable
     */
    readonly enableAuthority?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html#enable_https CssClusterV1#enable_https}.
     *
     * @stability stable
     */
    readonly enableHttps?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html#expect_node_num CssClusterV1#expect_node_num}.
     *
     * @stability stable
     */
    readonly expectNodeNum?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html#name CssClusterV1#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * datastore block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html#datastore CssClusterV1#datastore}
     *
     * @stability stable
     */
    readonly datastore?: CssClusterV1Datastore;
    /**
     * node_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html#node_config CssClusterV1#node_config}
     *
     * @stability stable
     */
    readonly nodeConfig: CssClusterV1NodeConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html#timeouts CssClusterV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CssClusterV1Timeouts;
}
/**
 * @stability stable
 */
export declare class CssClusterV1Nodes extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export interface CssClusterV1Datastore {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html#type CssClusterV1#type}.
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html#version CssClusterV1#version}.
     *
     * @stability stable
     */
    readonly version?: string;
}
/**
 * @stability stable
 */
export declare class CssClusterV1DatastoreOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string | undefined;
    /**
     * @stability stable
     */
    set type(value: string | undefined);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string | undefined;
    /**
     * @stability stable
     */
    set version(value: string | undefined);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CssClusterV1NodeConfigNetworkInfo {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html#network_id CssClusterV1#network_id}.
     *
     * @stability stable
     */
    readonly networkId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html#security_group_id CssClusterV1#security_group_id}.
     *
     * @stability stable
     */
    readonly securityGroupId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html#vpc_id CssClusterV1#vpc_id}.
     *
     * @stability stable
     */
    readonly vpcId: string;
}
/**
 * @stability stable
 */
export declare class CssClusterV1NodeConfigNetworkInfoOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _networkId?;
    /**
     * @stability stable
     */
    get networkId(): string;
    /**
     * @stability stable
     */
    set networkId(value: string);
    /**
     * @stability stable
     */
    get networkIdInput(): string | undefined;
    private _securityGroupId?;
    /**
     * @stability stable
     */
    get securityGroupId(): string;
    /**
     * @stability stable
     */
    set securityGroupId(value: string);
    /**
     * @stability stable
     */
    get securityGroupIdInput(): string | undefined;
    private _vpcId?;
    /**
     * @stability stable
     */
    get vpcId(): string;
    /**
     * @stability stable
     */
    set vpcId(value: string);
    /**
     * @stability stable
     */
    get vpcIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CssClusterV1NodeConfigVolume {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html#encryption_key CssClusterV1#encryption_key}.
     *
     * @stability stable
     */
    readonly encryptionKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html#size CssClusterV1#size}.
     *
     * @stability stable
     */
    readonly size: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html#volume_type CssClusterV1#volume_type}.
     *
     * @stability stable
     */
    readonly volumeType: string;
}
/**
 * @stability stable
 */
export declare class CssClusterV1NodeConfigVolumeOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _encryptionKey?;
    /**
     * @stability stable
     */
    get encryptionKey(): string | undefined;
    /**
     * @stability stable
     */
    set encryptionKey(value: string | undefined);
    /**
     * @stability stable
     */
    resetEncryptionKey(): void;
    /**
     * @stability stable
     */
    get encryptionKeyInput(): string | undefined;
    private _size?;
    /**
     * @stability stable
     */
    get size(): number;
    /**
     * @stability stable
     */
    set size(value: number);
    /**
     * @stability stable
     */
    get sizeInput(): number | undefined;
    private _volumeType?;
    /**
     * @stability stable
     */
    get volumeType(): string;
    /**
     * @stability stable
     */
    set volumeType(value: string);
    /**
     * @stability stable
     */
    get volumeTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CssClusterV1NodeConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html#availability_zone CssClusterV1#availability_zone}.
     *
     * @stability stable
     */
    readonly availabilityZone?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html#flavor CssClusterV1#flavor}.
     *
     * @stability stable
     */
    readonly flavor: string;
    /**
     * network_info block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html#network_info CssClusterV1#network_info}
     *
     * @stability stable
     */
    readonly networkInfo: CssClusterV1NodeConfigNetworkInfo;
    /**
     * volume block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html#volume CssClusterV1#volume}
     *
     * @stability stable
     */
    readonly volume: CssClusterV1NodeConfigVolume;
}
/**
 * @stability stable
 */
export declare class CssClusterV1NodeConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _availabilityZone?;
    /**
     * @stability stable
     */
    get availabilityZone(): string | undefined;
    /**
     * @stability stable
     */
    set availabilityZone(value: string | undefined);
    /**
     * @stability stable
     */
    resetAvailabilityZone(): void;
    /**
     * @stability stable
     */
    get availabilityZoneInput(): string | undefined;
    private _flavor?;
    /**
     * @stability stable
     */
    get flavor(): string;
    /**
     * @stability stable
     */
    set flavor(value: string);
    /**
     * @stability stable
     */
    get flavorInput(): string | undefined;
    private _networkInfo?;
    private __networkInfoOutput;
    /**
     * @stability stable
     */
    get networkInfo(): CssClusterV1NodeConfigNetworkInfoOutputReference;
    /**
     * @stability stable
     */
    putNetworkInfo(value: CssClusterV1NodeConfigNetworkInfo): void;
    /**
     * @stability stable
     */
    get networkInfoInput(): CssClusterV1NodeConfigNetworkInfo | undefined;
    private _volume?;
    private __volumeOutput;
    /**
     * @stability stable
     */
    get volume(): CssClusterV1NodeConfigVolumeOutputReference;
    /**
     * @stability stable
     */
    putVolume(value: CssClusterV1NodeConfigVolume): void;
    /**
     * @stability stable
     */
    get volumeInput(): CssClusterV1NodeConfigVolume | undefined;
}
/**
 * @stability stable
 */
export interface CssClusterV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html#create CssClusterV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html#update CssClusterV1#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class CssClusterV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html opentelekomcloud_css_cluster_v1}.
 *
 * @stability stable
 */
export declare class CssClusterV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_cluster_v1.html opentelekomcloud_css_cluster_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CssClusterV1Config);
    private _adminPass?;
    /**
     * @stability stable
     */
    get adminPass(): string | undefined;
    /**
     * @stability stable
     */
    set adminPass(value: string | undefined);
    /**
     * @stability stable
     */
    resetAdminPass(): void;
    /**
     * @stability stable
     */
    get adminPassInput(): string | undefined;
    /**
     * @stability stable
     */
    get created(): string;
    private _enableAuthority?;
    /**
     * @stability stable
     */
    get enableAuthority(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enableAuthority(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnableAuthority(): void;
    /**
     * @stability stable
     */
    get enableAuthorityInput(): boolean | cdktf.IResolvable | undefined;
    private _enableHttps?;
    /**
     * @stability stable
     */
    get enableHttps(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enableHttps(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnableHttps(): void;
    /**
     * @stability stable
     */
    get enableHttpsInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get endpoint(): string;
    private _expectNodeNum?;
    /**
     * @stability stable
     */
    get expectNodeNum(): number | undefined;
    /**
     * @stability stable
     */
    set expectNodeNum(value: number | undefined);
    /**
     * @stability stable
     */
    resetExpectNodeNum(): void;
    /**
     * @stability stable
     */
    get expectNodeNumInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    nodes(index: string): CssClusterV1Nodes;
    /**
     * @stability stable
     */
    get updated(): string;
    private _datastore?;
    private __datastoreOutput;
    /**
     * @stability stable
     */
    get datastore(): CssClusterV1DatastoreOutputReference;
    /**
     * @stability stable
     */
    putDatastore(value: CssClusterV1Datastore | undefined): void;
    /**
     * @stability stable
     */
    resetDatastore(): void;
    /**
     * @stability stable
     */
    get datastoreInput(): CssClusterV1Datastore | undefined;
    private _nodeConfig?;
    private __nodeConfigOutput;
    /**
     * @stability stable
     */
    get nodeConfig(): CssClusterV1NodeConfigOutputReference;
    /**
     * @stability stable
     */
    putNodeConfig(value: CssClusterV1NodeConfig): void;
    /**
     * @stability stable
     */
    get nodeConfigInput(): CssClusterV1NodeConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): CssClusterV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CssClusterV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CssClusterV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
