import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CssSnapshotConfigurationV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1.html#automatic CssSnapshotConfigurationV1#automatic}.
     *
     * @stability stable
     */
    readonly automatic?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1.html#cluster_id CssSnapshotConfigurationV1#cluster_id}.
     *
     * @stability stable
     */
    readonly clusterId: string;
    /**
     * configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1.html#configuration CssSnapshotConfigurationV1#configuration}
     *
     * @stability stable
     */
    readonly configuration?: CssSnapshotConfigurationV1Configuration;
    /**
     * creation_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1.html#creation_policy CssSnapshotConfigurationV1#creation_policy}
     *
     * @stability stable
     */
    readonly creationPolicy?: CssSnapshotConfigurationV1CreationPolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1.html#timeouts CssSnapshotConfigurationV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CssSnapshotConfigurationV1Timeouts;
}
/**
 * @stability stable
 */
export interface CssSnapshotConfigurationV1Configuration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1.html#agency CssSnapshotConfigurationV1#agency}.
     *
     * @stability stable
     */
    readonly agency: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1.html#bucket CssSnapshotConfigurationV1#bucket}.
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1.html#kms_id CssSnapshotConfigurationV1#kms_id}.
     *
     * @stability stable
     */
    readonly kmsId?: string;
}
/**
 * @stability stable
 */
export declare class CssSnapshotConfigurationV1ConfigurationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _agency?;
    /**
     * @stability stable
     */
    get agency(): string;
    /**
     * @stability stable
     */
    set agency(value: string);
    /**
     * @stability stable
     */
    get agencyInput(): string | undefined;
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    private _kmsId?;
    /**
     * @stability stable
     */
    get kmsId(): string | undefined;
    /**
     * @stability stable
     */
    set kmsId(value: string | undefined);
    /**
     * @stability stable
     */
    resetKmsId(): void;
    /**
     * @stability stable
     */
    get kmsIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CssSnapshotConfigurationV1CreationPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1.html#delete_auto CssSnapshotConfigurationV1#delete_auto}.
     *
     * @stability stable
     */
    readonly deleteAuto?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1.html#enable CssSnapshotConfigurationV1#enable}.
     *
     * @stability stable
     */
    readonly enable: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1.html#keepday CssSnapshotConfigurationV1#keepday}.
     *
     * @stability stable
     */
    readonly keepday: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1.html#period CssSnapshotConfigurationV1#period}.
     *
     * @stability stable
     */
    readonly period: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1.html#prefix CssSnapshotConfigurationV1#prefix}.
     *
     * @stability stable
     */
    readonly prefix: string;
}
/**
 * @stability stable
 */
export declare class CssSnapshotConfigurationV1CreationPolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _deleteAuto?;
    /**
     * @stability stable
     */
    get deleteAuto(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set deleteAuto(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDeleteAuto(): void;
    /**
     * @stability stable
     */
    get deleteAutoInput(): boolean | cdktf.IResolvable | undefined;
    private _enable?;
    /**
     * @stability stable
     */
    get enable(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enable(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enableInput(): boolean | cdktf.IResolvable | undefined;
    private _keepday?;
    /**
     * @stability stable
     */
    get keepday(): number;
    /**
     * @stability stable
     */
    set keepday(value: number);
    /**
     * @stability stable
     */
    get keepdayInput(): number | undefined;
    private _period?;
    /**
     * @stability stable
     */
    get period(): string;
    /**
     * @stability stable
     */
    set period(value: string);
    /**
     * @stability stable
     */
    get periodInput(): string | undefined;
    private _prefix?;
    /**
     * @stability stable
     */
    get prefix(): string;
    /**
     * @stability stable
     */
    set prefix(value: string);
    /**
     * @stability stable
     */
    get prefixInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CssSnapshotConfigurationV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1.html#create CssSnapshotConfigurationV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1.html#update CssSnapshotConfigurationV1#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class CssSnapshotConfigurationV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1.html opentelekomcloud_css_snapshot_configuration_v1}.
 *
 * @stability stable
 */
export declare class CssSnapshotConfigurationV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/css_snapshot_configuration_v1.html opentelekomcloud_css_snapshot_configuration_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CssSnapshotConfigurationV1Config);
    private _automatic?;
    /**
     * @stability stable
     */
    get automatic(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set automatic(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAutomatic(): void;
    /**
     * @stability stable
     */
    get automaticInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get basePath(): string;
    private _clusterId?;
    /**
     * @stability stable
     */
    get clusterId(): string;
    /**
     * @stability stable
     */
    set clusterId(value: string);
    /**
     * @stability stable
     */
    get clusterIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _configuration?;
    private __configurationOutput;
    /**
     * @stability stable
     */
    get configuration(): CssSnapshotConfigurationV1ConfigurationOutputReference;
    /**
     * @stability stable
     */
    putConfiguration(value: CssSnapshotConfigurationV1Configuration | undefined): void;
    /**
     * @stability stable
     */
    resetConfiguration(): void;
    /**
     * @stability stable
     */
    get configurationInput(): CssSnapshotConfigurationV1Configuration | undefined;
    private _creationPolicy?;
    private __creationPolicyOutput;
    /**
     * @stability stable
     */
    get creationPolicy(): CssSnapshotConfigurationV1CreationPolicyOutputReference;
    /**
     * @stability stable
     */
    putCreationPolicy(value: CssSnapshotConfigurationV1CreationPolicy | undefined): void;
    /**
     * @stability stable
     */
    resetCreationPolicy(): void;
    /**
     * @stability stable
     */
    get creationPolicyInput(): CssSnapshotConfigurationV1CreationPolicy | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): CssSnapshotConfigurationV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CssSnapshotConfigurationV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CssSnapshotConfigurationV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
