import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CtsTrackerV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1.html#bucket_name CtsTrackerV1#bucket_name}.
     *
     * @stability stable
     */
    readonly bucketName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1.html#file_prefix_name CtsTrackerV1#file_prefix_name}.
     *
     * @stability stable
     */
    readonly filePrefixName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1.html#is_send_all_key_operation CtsTrackerV1#is_send_all_key_operation}.
     *
     * @stability stable
     */
    readonly isSendAllKeyOperation?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1.html#is_support_smn CtsTrackerV1#is_support_smn}.
     *
     * @stability stable
     */
    readonly isSupportSmn: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1.html#need_notify_user_list CtsTrackerV1#need_notify_user_list}.
     *
     * @stability stable
     */
    readonly needNotifyUserList?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1.html#operations CtsTrackerV1#operations}.
     *
     * @stability stable
     */
    readonly operations?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1.html#project_name CtsTrackerV1#project_name}.
     *
     * @stability stable
     */
    readonly projectName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1.html#region CtsTrackerV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1.html#status CtsTrackerV1#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1.html#topic_id CtsTrackerV1#topic_id}.
     *
     * @stability stable
     */
    readonly topicId?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1.html#timeouts CtsTrackerV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CtsTrackerV1Timeouts;
}
/**
 * @stability stable
 */
export interface CtsTrackerV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1.html#create CtsTrackerV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1.html#delete CtsTrackerV1#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class CtsTrackerV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1.html opentelekomcloud_cts_tracker_v1}.
 *
 * @stability stable
 */
export declare class CtsTrackerV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/cts_tracker_v1.html opentelekomcloud_cts_tracker_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CtsTrackerV1Config);
    private _bucketName?;
    /**
     * @stability stable
     */
    get bucketName(): string;
    /**
     * @stability stable
     */
    set bucketName(value: string);
    /**
     * @stability stable
     */
    get bucketNameInput(): string | undefined;
    private _filePrefixName?;
    /**
     * @stability stable
     */
    get filePrefixName(): string | undefined;
    /**
     * @stability stable
     */
    set filePrefixName(value: string | undefined);
    /**
     * @stability stable
     */
    resetFilePrefixName(): void;
    /**
     * @stability stable
     */
    get filePrefixNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _isSendAllKeyOperation?;
    /**
     * @stability stable
     */
    get isSendAllKeyOperation(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isSendAllKeyOperation(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsSendAllKeyOperation(): void;
    /**
     * @stability stable
     */
    get isSendAllKeyOperationInput(): boolean | cdktf.IResolvable | undefined;
    private _isSupportSmn?;
    /**
     * @stability stable
     */
    get isSupportSmn(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isSupportSmn(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get isSupportSmnInput(): boolean | cdktf.IResolvable | undefined;
    private _needNotifyUserList?;
    /**
     * @stability stable
     */
    get needNotifyUserList(): string[] | undefined;
    /**
     * @stability stable
     */
    set needNotifyUserList(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetNeedNotifyUserList(): void;
    /**
     * @stability stable
     */
    get needNotifyUserListInput(): string[] | undefined;
    private _operations?;
    /**
     * @stability stable
     */
    get operations(): string[] | undefined;
    /**
     * @stability stable
     */
    set operations(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetOperations(): void;
    /**
     * @stability stable
     */
    get operationsInput(): string[] | undefined;
    private _projectName?;
    /**
     * @stability stable
     */
    get projectName(): string | undefined;
    /**
     * @stability stable
     */
    set projectName(value: string | undefined);
    /**
     * @stability stable
     */
    resetProjectName(): void;
    /**
     * @stability stable
     */
    get projectNameInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string | undefined;
    /**
     * @stability stable
     */
    set status(value: string | undefined);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _topicId?;
    /**
     * @stability stable
     */
    get topicId(): string | undefined;
    /**
     * @stability stable
     */
    set topicId(value: string | undefined);
    /**
     * @stability stable
     */
    resetTopicId(): void;
    /**
     * @stability stable
     */
    get topicIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get trackerName(): string;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): CtsTrackerV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CtsTrackerV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CtsTrackerV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
