import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudAntiddosV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/antiddos_v1.html#floating_ip_address DataOpentelekomcloudAntiddosV1#floating_ip_address}.
     *
     * @stability stable
     */
    readonly floatingIpAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/antiddos_v1.html#floating_ip_id DataOpentelekomcloudAntiddosV1#floating_ip_id}.
     *
     * @stability stable
     */
    readonly floatingIpId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/antiddos_v1.html#region DataOpentelekomcloudAntiddosV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/antiddos_v1.html#status DataOpentelekomcloudAntiddosV1#status}.
     *
     * @stability stable
     */
    readonly status?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/antiddos_v1.html opentelekomcloud_antiddos_v1}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudAntiddosV1 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/antiddos_v1.html opentelekomcloud_antiddos_v1} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudAntiddosV1Config);
    /**
     * @stability stable
     */
    get bpsAttack(): any;
    /**
     * @stability stable
     */
    get bpsIn(): any;
    /**
     * @stability stable
     */
    get endTime(): any;
    private _floatingIpAddress?;
    /**
     * @stability stable
     */
    get floatingIpAddress(): string | undefined;
    /**
     * @stability stable
     */
    set floatingIpAddress(value: string | undefined);
    /**
     * @stability stable
     */
    resetFloatingIpAddress(): void;
    /**
     * @stability stable
     */
    get floatingIpAddressInput(): string | undefined;
    private _floatingIpId?;
    /**
     * @stability stable
     */
    get floatingIpId(): string | undefined;
    /**
     * @stability stable
     */
    set floatingIpId(value: string | undefined);
    /**
     * @stability stable
     */
    resetFloatingIpId(): void;
    /**
     * @stability stable
     */
    get floatingIpIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get networkType(): string;
    /**
     * @stability stable
     */
    get periodStart(): any;
    /**
     * @stability stable
     */
    get ppsAttack(): any;
    /**
     * @stability stable
     */
    get ppsIn(): any;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get startTime(): any;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string | undefined;
    /**
     * @stability stable
     */
    set status(value: string | undefined);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    /**
     * @stability stable
     */
    get totalBps(): any;
    /**
     * @stability stable
     */
    get totalPps(): any;
    /**
     * @stability stable
     */
    get trafficCleaningStatus(): any;
    /**
     * @stability stable
     */
    get triggerBps(): any;
    /**
     * @stability stable
     */
    get triggerHttpPps(): any;
    /**
     * @stability stable
     */
    get triggerPps(): any;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
