import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudCceClusterV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_cluster_v3.html#cluster_type DataOpentelekomcloudCceClusterV3#cluster_type}.
     *
     * @stability stable
     */
    readonly clusterType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_cluster_v3.html#name DataOpentelekomcloudCceClusterV3#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_cluster_v3.html#region DataOpentelekomcloudCceClusterV3#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_cluster_v3.html#status DataOpentelekomcloudCceClusterV3#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_cluster_v3.html#vpc_id DataOpentelekomcloudCceClusterV3#vpc_id}.
     *
     * @stability stable
     */
    readonly vpcId?: string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudCceClusterV3CertificateClusters extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get certificateAuthorityData(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get server(): string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudCceClusterV3CertificateUsers extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get clientCertificateData(): string;
    /**
     * @stability stable
     */
    get clientKeyData(): string;
    /**
     * @stability stable
     */
    get name(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_cluster_v3.html opentelekomcloud_cce_cluster_v3}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudCceClusterV3 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_cluster_v3.html opentelekomcloud_cce_cluster_v3} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudCceClusterV3Config);
    /**
     * @stability stable
     */
    get authenticationMode(): string;
    /**
     * @stability stable
     */
    get billingMode(): number;
    /**
     * @stability stable
     */
    certificateClusters(index: string): DataOpentelekomcloudCceClusterV3CertificateClusters;
    /**
     * @stability stable
     */
    certificateUsers(index: string): DataOpentelekomcloudCceClusterV3CertificateUsers;
    private _clusterType?;
    /**
     * @stability stable
     */
    get clusterType(): string | undefined;
    /**
     * @stability stable
     */
    set clusterType(value: string | undefined);
    /**
     * @stability stable
     */
    resetClusterType(): void;
    /**
     * @stability stable
     */
    get clusterTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get clusterVersion(): string;
    /**
     * @stability stable
     */
    get containerNetworkCidr(): string;
    /**
     * @stability stable
     */
    get containerNetworkType(): string;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get external(): string;
    /**
     * @stability stable
     */
    get externalOtc(): string;
    /**
     * @stability stable
     */
    get flavorId(): string;
    /**
     * @stability stable
     */
    get highwaySubnetId(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get internal(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string | undefined;
    /**
     * @stability stable
     */
    set status(value: string | undefined);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    /**
     * @stability stable
     */
    get subnetId(): string;
    private _vpcId?;
    /**
     * @stability stable
     */
    get vpcId(): string | undefined;
    /**
     * @stability stable
     */
    set vpcId(value: string | undefined);
    /**
     * @stability stable
     */
    resetVpcId(): void;
    /**
     * @stability stable
     */
    get vpcIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
