import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudCceNodeV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_node_v3.html#cluster_id DataOpentelekomcloudCceNodeV3#cluster_id}.
     *
     * @stability stable
     */
    readonly clusterId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_node_v3.html#name DataOpentelekomcloudCceNodeV3#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_node_v3.html#node_id DataOpentelekomcloudCceNodeV3#node_id}.
     *
     * @stability stable
     */
    readonly nodeId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_node_v3.html#region DataOpentelekomcloudCceNodeV3#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_node_v3.html#status DataOpentelekomcloudCceNodeV3#status}.
     *
     * @stability stable
     */
    readonly status?: string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudCceNodeV3DataVolumes extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get diskSize(): number;
    /**
     * @stability stable
     */
    get extendParam(): string;
    /**
     * @stability stable
     */
    get kmsId(): string;
    /**
     * @stability stable
     */
    get volumeType(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_node_v3.html opentelekomcloud_cce_node_v3}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudCceNodeV3 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/cce_node_v3.html opentelekomcloud_cce_node_v3} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOpentelekomcloudCceNodeV3Config);
    /**
     * @stability stable
     */
    get availabilityZone(): string;
    /**
     * @stability stable
     */
    get bandwidthSize(): number;
    /**
     * @stability stable
     */
    get billingMode(): number;
    /**
     * @stability stable
     */
    get chargeMode(): string;
    private _clusterId?;
    /**
     * @stability stable
     */
    get clusterId(): string;
    /**
     * @stability stable
     */
    set clusterId(value: string);
    /**
     * @stability stable
     */
    get clusterIdInput(): string | undefined;
    /**
     * @stability stable
     */
    dataVolumes(index: string): DataOpentelekomcloudCceNodeV3DataVolumes;
    /**
     * @stability stable
     */
    get diskSize(): number;
    /**
     * @stability stable
     */
    get eipCount(): number;
    /**
     * @stability stable
     */
    get eipIds(): string[];
    /**
     * @stability stable
     */
    get flavorId(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get ipType(): string;
    /**
     * @stability stable
     */
    get keyPair(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nodeId?;
    /**
     * @stability stable
     */
    get nodeId(): string | undefined;
    /**
     * @stability stable
     */
    set nodeId(value: string | undefined);
    /**
     * @stability stable
     */
    resetNodeId(): void;
    /**
     * @stability stable
     */
    get nodeIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get privateIp(): string;
    /**
     * @stability stable
     */
    get publicIp(): string;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get serverId(): string;
    /**
     * @stability stable
     */
    get shareType(): string;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string | undefined;
    /**
     * @stability stable
     */
    set status(value: string | undefined);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    /**
     * @stability stable
     */
    get volumeType(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
