import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudComputeBmsServerV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/compute_bms_server_v2.html#flavor_id DataOpentelekomcloudComputeBmsServerV2#flavor_id}.
     *
     * @stability stable
     */
    readonly flavorId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/compute_bms_server_v2.html#host_status DataOpentelekomcloudComputeBmsServerV2#host_status}.
     *
     * @stability stable
     */
    readonly hostStatus?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/compute_bms_server_v2.html#id DataOpentelekomcloudComputeBmsServerV2#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/compute_bms_server_v2.html#image_id DataOpentelekomcloudComputeBmsServerV2#image_id}.
     *
     * @stability stable
     */
    readonly imageId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/compute_bms_server_v2.html#key_name DataOpentelekomcloudComputeBmsServerV2#key_name}.
     *
     * @stability stable
     */
    readonly keyName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/compute_bms_server_v2.html#name DataOpentelekomcloudComputeBmsServerV2#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/compute_bms_server_v2.html#region DataOpentelekomcloudComputeBmsServerV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/compute_bms_server_v2.html#status DataOpentelekomcloudComputeBmsServerV2#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/compute_bms_server_v2.html#user_id DataOpentelekomcloudComputeBmsServerV2#user_id}.
     *
     * @stability stable
     */
    readonly userId?: string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudComputeBmsServerV2Network extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get ip(): string;
    /**
     * @stability stable
     */
    get mac(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get version(): number;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudComputeBmsServerV2SecurityGroups extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/compute_bms_server_v2.html opentelekomcloud_compute_bms_server_v2}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudComputeBmsServerV2 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/compute_bms_server_v2.html opentelekomcloud_compute_bms_server_v2} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudComputeBmsServerV2Config);
    /**
     * @stability stable
     */
    get accessIpV4(): string;
    /**
     * @stability stable
     */
    get accessIpV6(): string;
    /**
     * @stability stable
     */
    get availabilityZone(): string;
    /**
     * @stability stable
     */
    get configDrive(): string;
    /**
     * @stability stable
     */
    get description(): string;
    private _flavorId?;
    /**
     * @stability stable
     */
    get flavorId(): string | undefined;
    /**
     * @stability stable
     */
    set flavorId(value: string | undefined);
    /**
     * @stability stable
     */
    resetFlavorId(): void;
    /**
     * @stability stable
     */
    get flavorIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get hostId(): string;
    private _hostStatus?;
    /**
     * @stability stable
     */
    get hostStatus(): string | undefined;
    /**
     * @stability stable
     */
    set hostStatus(value: string | undefined);
    /**
     * @stability stable
     */
    resetHostStatus(): void;
    /**
     * @stability stable
     */
    get hostStatusInput(): string | undefined;
    /**
     * @stability stable
     */
    get hypervisorHostname(): string;
    private _id?;
    /**
     * @stability stable
     */
    get id(): string | undefined;
    /**
     * @stability stable
     */
    set id(value: string | undefined);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    private _imageId?;
    /**
     * @stability stable
     */
    get imageId(): string | undefined;
    /**
     * @stability stable
     */
    set imageId(value: string | undefined);
    /**
     * @stability stable
     */
    resetImageId(): void;
    /**
     * @stability stable
     */
    get imageIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get instanceName(): string;
    /**
     * @stability stable
     */
    get kernelId(): string;
    private _keyName?;
    /**
     * @stability stable
     */
    get keyName(): string | undefined;
    /**
     * @stability stable
     */
    set keyName(value: string | undefined);
    /**
     * @stability stable
     */
    resetKeyName(): void;
    /**
     * @stability stable
     */
    get keyNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get locked(): any;
    /**
     * @stability stable
     */
    metadata(key: string): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    network(index: string): DataOpentelekomcloudComputeBmsServerV2Network;
    /**
     * @stability stable
     */
    get progress(): number;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    securityGroups(index: string): DataOpentelekomcloudComputeBmsServerV2SecurityGroups;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string | undefined;
    /**
     * @stability stable
     */
    set status(value: string | undefined);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    get tenantId(): string;
    private _userId?;
    /**
     * @stability stable
     */
    get userId(): string | undefined;
    /**
     * @stability stable
     */
    set userId(value: string | undefined);
    /**
     * @stability stable
     */
    resetUserId(): void;
    /**
     * @stability stable
     */
    get userIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
