import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudCsbsBackupPolicyV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_policy_v1.html#name DataOpentelekomcloudCsbsBackupPolicyV1#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_policy_v1.html#region DataOpentelekomcloudCsbsBackupPolicyV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_policy_v1.html#status DataOpentelekomcloudCsbsBackupPolicyV1#status}.
     *
     * @stability stable
     */
    readonly status?: string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudCsbsBackupPolicyV1Resource extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudCsbsBackupPolicyV1ScheduledOperation extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get enabled(): any;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get maxBackups(): number;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get operationType(): string;
    /**
     * @stability stable
     */
    get permanent(): any;
    /**
     * @stability stable
     */
    get retentionDurationDays(): number;
    /**
     * @stability stable
     */
    get triggerId(): string;
    /**
     * @stability stable
     */
    get triggerName(): string;
    /**
     * @stability stable
     */
    get triggerPattern(): string;
    /**
     * @stability stable
     */
    get triggerType(): string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudCsbsBackupPolicyV1Tags extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_policy_v1.html opentelekomcloud_csbs_backup_policy_v1}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudCsbsBackupPolicyV1 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_policy_v1.html opentelekomcloud_csbs_backup_policy_v1} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudCsbsBackupPolicyV1Config);
    /**
     * @stability stable
     */
    common(key: string): string;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get providerId(): string;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    resource(index: string): DataOpentelekomcloudCsbsBackupPolicyV1Resource;
    /**
     * @stability stable
     */
    scheduledOperation(index: string): DataOpentelekomcloudCsbsBackupPolicyV1ScheduledOperation;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string | undefined;
    /**
     * @stability stable
     */
    set status(value: string | undefined);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(index: string): DataOpentelekomcloudCsbsBackupPolicyV1Tags;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
