import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudCsbsBackupV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1.html#backup_name DataOpentelekomcloudCsbsBackupV1#backup_name}.
     *
     * @stability stable
     */
    readonly backupName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1.html#backup_record_id DataOpentelekomcloudCsbsBackupV1#backup_record_id}.
     *
     * @stability stable
     */
    readonly backupRecordId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1.html#id DataOpentelekomcloudCsbsBackupV1#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1.html#policy_id DataOpentelekomcloudCsbsBackupV1#policy_id}.
     *
     * @stability stable
     */
    readonly policyId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1.html#region DataOpentelekomcloudCsbsBackupV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1.html#resource_id DataOpentelekomcloudCsbsBackupV1#resource_id}.
     *
     * @stability stable
     */
    readonly resourceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1.html#resource_name DataOpentelekomcloudCsbsBackupV1#resource_name}.
     *
     * @stability stable
     */
    readonly resourceName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1.html#resource_type DataOpentelekomcloudCsbsBackupV1#resource_type}.
     *
     * @stability stable
     */
    readonly resourceType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1.html#status DataOpentelekomcloudCsbsBackupV1#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1.html#vm_ip DataOpentelekomcloudCsbsBackupV1#vm_ip}.
     *
     * @stability stable
     */
    readonly vmIp?: string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudCsbsBackupV1Tags extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudCsbsBackupV1VmMetadata extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get cloudServiceType(): string;
    /**
     * @stability stable
     */
    get disk(): number;
    /**
     * @stability stable
     */
    get eip(): string;
    /**
     * @stability stable
     */
    get imageType(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get privateIp(): string;
    /**
     * @stability stable
     */
    get ram(): number;
    /**
     * @stability stable
     */
    get vcpus(): number;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudCsbsBackupV1VolumeBackups extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get averageSpeed(): number;
    /**
     * @stability stable
     */
    get bootable(): any;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get imageType(): string;
    /**
     * @stability stable
     */
    get incremental(): any;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get size(): number;
    /**
     * @stability stable
     */
    get snapshotId(): string;
    /**
     * @stability stable
     */
    get sourceVolumeId(): string;
    /**
     * @stability stable
     */
    get sourceVolumeName(): string;
    /**
     * @stability stable
     */
    get sourceVolumeSize(): number;
    /**
     * @stability stable
     */
    get spaceSavingRatio(): number;
    /**
     * @stability stable
     */
    get status(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1.html opentelekomcloud_csbs_backup_v1}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudCsbsBackupV1 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/csbs_backup_v1.html opentelekomcloud_csbs_backup_v1} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudCsbsBackupV1Config);
    /**
     * @stability stable
     */
    get autoTrigger(): any;
    /**
     * @stability stable
     */
    get averageSpeed(): number;
    private _backupName?;
    /**
     * @stability stable
     */
    get backupName(): string | undefined;
    /**
     * @stability stable
     */
    set backupName(value: string | undefined);
    /**
     * @stability stable
     */
    resetBackupName(): void;
    /**
     * @stability stable
     */
    get backupNameInput(): string | undefined;
    private _backupRecordId?;
    /**
     * @stability stable
     */
    get backupRecordId(): string | undefined;
    /**
     * @stability stable
     */
    set backupRecordId(value: string | undefined);
    /**
     * @stability stable
     */
    resetBackupRecordId(): void;
    /**
     * @stability stable
     */
    get backupRecordIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get description(): string;
    private _id?;
    /**
     * @stability stable
     */
    get id(): string | undefined;
    /**
     * @stability stable
     */
    set id(value: string | undefined);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    private _policyId?;
    /**
     * @stability stable
     */
    get policyId(): string | undefined;
    /**
     * @stability stable
     */
    set policyId(value: string | undefined);
    /**
     * @stability stable
     */
    resetPolicyId(): void;
    /**
     * @stability stable
     */
    get policyIdInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _resourceId?;
    /**
     * @stability stable
     */
    get resourceId(): string | undefined;
    /**
     * @stability stable
     */
    set resourceId(value: string | undefined);
    /**
     * @stability stable
     */
    resetResourceId(): void;
    /**
     * @stability stable
     */
    get resourceIdInput(): string | undefined;
    private _resourceName?;
    /**
     * @stability stable
     */
    get resourceName(): string | undefined;
    /**
     * @stability stable
     */
    set resourceName(value: string | undefined);
    /**
     * @stability stable
     */
    resetResourceName(): void;
    /**
     * @stability stable
     */
    get resourceNameInput(): string | undefined;
    private _resourceType?;
    /**
     * @stability stable
     */
    get resourceType(): string | undefined;
    /**
     * @stability stable
     */
    set resourceType(value: string | undefined);
    /**
     * @stability stable
     */
    resetResourceType(): void;
    /**
     * @stability stable
     */
    get resourceTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get size(): number;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string | undefined;
    /**
     * @stability stable
     */
    set status(value: string | undefined);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(index: string): DataOpentelekomcloudCsbsBackupV1Tags;
    private _vmIp?;
    /**
     * @stability stable
     */
    get vmIp(): string | undefined;
    /**
     * @stability stable
     */
    set vmIp(value: string | undefined);
    /**
     * @stability stable
     */
    resetVmIp(): void;
    /**
     * @stability stable
     */
    get vmIpInput(): string | undefined;
    /**
     * @stability stable
     */
    vmMetadata(index: string): DataOpentelekomcloudCsbsBackupV1VmMetadata;
    /**
     * @stability stable
     */
    volumeBackups(index: string): DataOpentelekomcloudCsbsBackupV1VolumeBackups;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
