import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudCssFlavorV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/css_flavor_v1.html#min_cpu DataOpentelekomcloudCssFlavorV1#min_cpu}.
     *
     * @stability stable
     */
    readonly minCpu?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/css_flavor_v1.html#min_ram DataOpentelekomcloudCssFlavorV1#min_ram}.
     *
     * @stability stable
     */
    readonly minRam?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/css_flavor_v1.html#name DataOpentelekomcloudCssFlavorV1#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/css_flavor_v1.html#type DataOpentelekomcloudCssFlavorV1#type}.
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/css_flavor_v1.html#version DataOpentelekomcloudCssFlavorV1#version}.
     *
     * @stability stable
     */
    readonly version?: string;
    /**
     * disk_range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/css_flavor_v1.html#disk_range DataOpentelekomcloudCssFlavorV1#disk_range}
     *
     * @stability stable
     */
    readonly diskRange?: DataOpentelekomcloudCssFlavorV1DiskRange;
}
/**
 * @stability stable
 */
export interface DataOpentelekomcloudCssFlavorV1DiskRange {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/css_flavor_v1.html#min_from DataOpentelekomcloudCssFlavorV1#min_from}.
     *
     * @stability stable
     */
    readonly minFrom?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/css_flavor_v1.html#min_to DataOpentelekomcloudCssFlavorV1#min_to}.
     *
     * @stability stable
     */
    readonly minTo?: number;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudCssFlavorV1DiskRangeOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _minFrom?;
    /**
     * @stability stable
     */
    get minFrom(): number | undefined;
    /**
     * @stability stable
     */
    set minFrom(value: number | undefined);
    /**
     * @stability stable
     */
    resetMinFrom(): void;
    /**
     * @stability stable
     */
    get minFromInput(): number | undefined;
    private _minTo?;
    /**
     * @stability stable
     */
    get minTo(): number | undefined;
    /**
     * @stability stable
     */
    set minTo(value: number | undefined);
    /**
     * @stability stable
     */
    resetMinTo(): void;
    /**
     * @stability stable
     */
    get minToInput(): number | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/css_flavor_v1.html opentelekomcloud_css_flavor_v1}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudCssFlavorV1 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/css_flavor_v1.html opentelekomcloud_css_flavor_v1} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudCssFlavorV1Config);
    /**
     * @stability stable
     */
    get cpu(): number;
    /**
     * @stability stable
     */
    get id(): string;
    private _minCpu?;
    /**
     * @stability stable
     */
    get minCpu(): number | undefined;
    /**
     * @stability stable
     */
    set minCpu(value: number | undefined);
    /**
     * @stability stable
     */
    resetMinCpu(): void;
    /**
     * @stability stable
     */
    get minCpuInput(): number | undefined;
    private _minRam?;
    /**
     * @stability stable
     */
    get minRam(): number | undefined;
    /**
     * @stability stable
     */
    set minRam(value: number | undefined);
    /**
     * @stability stable
     */
    resetMinRam(): void;
    /**
     * @stability stable
     */
    get minRamInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get ram(): number;
    /**
     * @stability stable
     */
    get region(): string;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string | undefined;
    /**
     * @stability stable
     */
    set type(value: string | undefined);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string | undefined;
    /**
     * @stability stable
     */
    set version(value: string | undefined);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
    private _diskRange?;
    private __diskRangeOutput;
    /**
     * @stability stable
     */
    get diskRange(): DataOpentelekomcloudCssFlavorV1DiskRangeOutputReference;
    /**
     * @stability stable
     */
    putDiskRange(value: DataOpentelekomcloudCssFlavorV1DiskRange | undefined): void;
    /**
     * @stability stable
     */
    resetDiskRange(): void;
    /**
     * @stability stable
     */
    get diskRangeInput(): DataOpentelekomcloudCssFlavorV1DiskRange | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
