import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudDdsFlavorsV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_flavors_v3.html#engine_name DataOpentelekomcloudDdsFlavorsV3#engine_name}.
     *
     * @stability stable
     */
    readonly engineName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_flavors_v3.html#memory DataOpentelekomcloudDdsFlavorsV3#memory}.
     *
     * @stability stable
     */
    readonly memory?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_flavors_v3.html#region DataOpentelekomcloudDdsFlavorsV3#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_flavors_v3.html#type DataOpentelekomcloudDdsFlavorsV3#type}.
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_flavors_v3.html#vcpus DataOpentelekomcloudDdsFlavorsV3#vcpus}.
     *
     * @stability stable
     */
    readonly vcpus?: string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudDdsFlavorsV3Flavors extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get azStatus(): any;
    /**
     * @stability stable
     */
    get memory(): string;
    /**
     * @stability stable
     */
    get specCode(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get vcpus(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_flavors_v3.html opentelekomcloud_dds_flavors_v3}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudDdsFlavorsV3 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_flavors_v3.html opentelekomcloud_dds_flavors_v3} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOpentelekomcloudDdsFlavorsV3Config);
    private _engineName?;
    /**
     * @stability stable
     */
    get engineName(): string;
    /**
     * @stability stable
     */
    set engineName(value: string);
    /**
     * @stability stable
     */
    get engineNameInput(): string | undefined;
    /**
     * @stability stable
     */
    flavors(index: string): DataOpentelekomcloudDdsFlavorsV3Flavors;
    /**
     * @stability stable
     */
    get id(): string;
    private _memory?;
    /**
     * @stability stable
     */
    get memory(): string | undefined;
    /**
     * @stability stable
     */
    set memory(value: string | undefined);
    /**
     * @stability stable
     */
    resetMemory(): void;
    /**
     * @stability stable
     */
    get memoryInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string | undefined;
    /**
     * @stability stable
     */
    set type(value: string | undefined);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _vcpus?;
    /**
     * @stability stable
     */
    get vcpus(): string | undefined;
    /**
     * @stability stable
     */
    set vcpus(value: string | undefined);
    /**
     * @stability stable
     */
    resetVcpus(): void;
    /**
     * @stability stable
     */
    get vcpusInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
