import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudDdsInstanceV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_instance_v3.html#datastore_type DataOpentelekomcloudDdsInstanceV3#datastore_type}.
     *
     * @stability stable
     */
    readonly datastoreType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_instance_v3.html#instance_id DataOpentelekomcloudDdsInstanceV3#instance_id}.
     *
     * @stability stable
     */
    readonly instanceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_instance_v3.html#name DataOpentelekomcloudDdsInstanceV3#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_instance_v3.html#subnet_id DataOpentelekomcloudDdsInstanceV3#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_instance_v3.html#vpc_id DataOpentelekomcloudDdsInstanceV3#vpc_id}.
     *
     * @stability stable
     */
    readonly vpcId?: string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudDdsInstanceV3BackupStrategy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get keepDays(): number;
    /**
     * @stability stable
     */
    get startTime(): string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudDdsInstanceV3Datastore extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get storageEngine(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get version(): string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudDdsInstanceV3Nodes extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get privateIp(): string;
    /**
     * @stability stable
     */
    get publicIp(): string;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_instance_v3.html opentelekomcloud_dds_instance_v3}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudDdsInstanceV3 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dds_instance_v3.html opentelekomcloud_dds_instance_v3} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudDdsInstanceV3Config);
    /**
     * @stability stable
     */
    backupStrategy(index: string): DataOpentelekomcloudDdsInstanceV3BackupStrategy;
    /**
     * @stability stable
     */
    datastore(index: string): DataOpentelekomcloudDdsInstanceV3Datastore;
    private _datastoreType?;
    /**
     * @stability stable
     */
    get datastoreType(): string | undefined;
    /**
     * @stability stable
     */
    set datastoreType(value: string | undefined);
    /**
     * @stability stable
     */
    resetDatastoreType(): void;
    /**
     * @stability stable
     */
    get datastoreTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get dbUsername(): string;
    /**
     * @stability stable
     */
    get diskEncryptionId(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _instanceId?;
    /**
     * @stability stable
     */
    get instanceId(): string | undefined;
    /**
     * @stability stable
     */
    set instanceId(value: string | undefined);
    /**
     * @stability stable
     */
    resetInstanceId(): void;
    /**
     * @stability stable
     */
    get instanceIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get mode(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    nodes(index: string): DataOpentelekomcloudDdsInstanceV3Nodes;
    /**
     * @stability stable
     */
    get payMode(): string;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    get securityGroupId(): string;
    /**
     * @stability stable
     */
    get ssl(): any;
    /**
     * @stability stable
     */
    get status(): string;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string | undefined;
    /**
     * @stability stable
     */
    set subnetId(value: string | undefined);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _vpcId?;
    /**
     * @stability stable
     */
    get vpcId(): string | undefined;
    /**
     * @stability stable
     */
    set vpcId(value: string | undefined);
    /**
     * @stability stable
     */
    resetVpcId(): void;
    /**
     * @stability stable
     */
    get vpcIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
