import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudDehServerV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/deh_server_v1.html#dedicated_host_id DataOpentelekomcloudDehServerV1#dedicated_host_id}.
     *
     * @stability stable
     */
    readonly dedicatedHostId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/deh_server_v1.html#region DataOpentelekomcloudDehServerV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/deh_server_v1.html#server_id DataOpentelekomcloudDehServerV1#server_id}.
     *
     * @stability stable
     */
    readonly serverId?: string;
    /**
     * addresses block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/deh_server_v1.html#addresses DataOpentelekomcloudDehServerV1#addresses}
     *
     * @stability stable
     */
    readonly addresses?: DataOpentelekomcloudDehServerV1Addresses[];
}
/**
 * @stability stable
 */
export interface DataOpentelekomcloudDehServerV1Addresses {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/deh_server_v1.html#fixed_ip_v4 DataOpentelekomcloudDehServerV1#fixed_ip_v4}.
     *
     * @stability stable
     */
    readonly fixedIpV4?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/deh_server_v1.html#name DataOpentelekomcloudDehServerV1#name}.
     *
     * @stability stable
     */
    readonly name?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/deh_server_v1.html opentelekomcloud_deh_server_v1}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudDehServerV1 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/deh_server_v1.html opentelekomcloud_deh_server_v1} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudDehServerV1Config);
    private _dedicatedHostId?;
    /**
     * @stability stable
     */
    get dedicatedHostId(): string | undefined;
    /**
     * @stability stable
     */
    set dedicatedHostId(value: string | undefined);
    /**
     * @stability stable
     */
    resetDedicatedHostId(): void;
    /**
     * @stability stable
     */
    get dedicatedHostIdInput(): string | undefined;
    /**
     * @stability stable
     */
    flavor(key: string): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    metadata(key: string): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _serverId?;
    /**
     * @stability stable
     */
    get serverId(): string | undefined;
    /**
     * @stability stable
     */
    set serverId(value: string | undefined);
    /**
     * @stability stable
     */
    resetServerId(): void;
    /**
     * @stability stable
     */
    get serverIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    get userId(): string;
    private _addresses?;
    /**
     * @stability stable
     */
    get addresses(): DataOpentelekomcloudDehServerV1Addresses[] | undefined;
    /**
     * @stability stable
     */
    set addresses(value: DataOpentelekomcloudDehServerV1Addresses[] | undefined);
    /**
     * @stability stable
     */
    resetAddresses(): void;
    /**
     * @stability stable
     */
    get addressesInput(): DataOpentelekomcloudDehServerV1Addresses[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
