import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudDmsProductV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dms_product_v1.html#bandwidth DataOpentelekomcloudDmsProductV1#bandwidth}.
     *
     * @stability stable
     */
    readonly bandwidth?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dms_product_v1.html#engine DataOpentelekomcloudDmsProductV1#engine}.
     *
     * @stability stable
     */
    readonly engine: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dms_product_v1.html#instance_type DataOpentelekomcloudDmsProductV1#instance_type}.
     *
     * @stability stable
     */
    readonly instanceType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dms_product_v1.html#io_type DataOpentelekomcloudDmsProductV1#io_type}.
     *
     * @stability stable
     */
    readonly ioType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dms_product_v1.html#node_num DataOpentelekomcloudDmsProductV1#node_num}.
     *
     * @stability stable
     */
    readonly nodeNum?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dms_product_v1.html#partition_num DataOpentelekomcloudDmsProductV1#partition_num}.
     *
     * @stability stable
     */
    readonly partitionNum?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dms_product_v1.html#storage DataOpentelekomcloudDmsProductV1#storage}.
     *
     * @stability stable
     */
    readonly storage?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dms_product_v1.html#storage_spec_code DataOpentelekomcloudDmsProductV1#storage_spec_code}.
     *
     * @stability stable
     */
    readonly storageSpecCode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dms_product_v1.html#version DataOpentelekomcloudDmsProductV1#version}.
     *
     * @stability stable
     */
    readonly version?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dms_product_v1.html#vm_specification DataOpentelekomcloudDmsProductV1#vm_specification}.
     *
     * @stability stable
     */
    readonly vmSpecification?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dms_product_v1.html opentelekomcloud_dms_product_v1}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudDmsProductV1 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dms_product_v1.html opentelekomcloud_dms_product_v1} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOpentelekomcloudDmsProductV1Config);
    private _bandwidth?;
    /**
     * @stability stable
     */
    get bandwidth(): string | undefined;
    /**
     * @stability stable
     */
    set bandwidth(value: string | undefined);
    /**
     * @stability stable
     */
    resetBandwidth(): void;
    /**
     * @stability stable
     */
    get bandwidthInput(): string | undefined;
    private _engine?;
    /**
     * @stability stable
     */
    get engine(): string;
    /**
     * @stability stable
     */
    set engine(value: string);
    /**
     * @stability stable
     */
    get engineInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _instanceType?;
    /**
     * @stability stable
     */
    get instanceType(): string;
    /**
     * @stability stable
     */
    set instanceType(value: string);
    /**
     * @stability stable
     */
    get instanceTypeInput(): string | undefined;
    private _ioType?;
    /**
     * @stability stable
     */
    get ioType(): string | undefined;
    /**
     * @stability stable
     */
    set ioType(value: string | undefined);
    /**
     * @stability stable
     */
    resetIoType(): void;
    /**
     * @stability stable
     */
    get ioTypeInput(): string | undefined;
    private _nodeNum?;
    /**
     * @stability stable
     */
    get nodeNum(): string | undefined;
    /**
     * @stability stable
     */
    set nodeNum(value: string | undefined);
    /**
     * @stability stable
     */
    resetNodeNum(): void;
    /**
     * @stability stable
     */
    get nodeNumInput(): string | undefined;
    private _partitionNum?;
    /**
     * @stability stable
     */
    get partitionNum(): string | undefined;
    /**
     * @stability stable
     */
    set partitionNum(value: string | undefined);
    /**
     * @stability stable
     */
    resetPartitionNum(): void;
    /**
     * @stability stable
     */
    get partitionNumInput(): string | undefined;
    private _storage?;
    /**
     * @stability stable
     */
    get storage(): string | undefined;
    /**
     * @stability stable
     */
    set storage(value: string | undefined);
    /**
     * @stability stable
     */
    resetStorage(): void;
    /**
     * @stability stable
     */
    get storageInput(): string | undefined;
    private _storageSpecCode?;
    /**
     * @stability stable
     */
    get storageSpecCode(): string | undefined;
    /**
     * @stability stable
     */
    set storageSpecCode(value: string | undefined);
    /**
     * @stability stable
     */
    resetStorageSpecCode(): void;
    /**
     * @stability stable
     */
    get storageSpecCodeInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string | undefined;
    /**
     * @stability stable
     */
    set version(value: string | undefined);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
    private _vmSpecification?;
    /**
     * @stability stable
     */
    get vmSpecification(): string | undefined;
    /**
     * @stability stable
     */
    set vmSpecification(value: string | undefined);
    /**
     * @stability stable
     */
    resetVmSpecification(): void;
    /**
     * @stability stable
     */
    get vmSpecificationInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
