import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudDnsZoneV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dns_zone_v2.html#description DataOpentelekomcloudDnsZoneV2#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dns_zone_v2.html#email DataOpentelekomcloudDnsZoneV2#email}.
     *
     * @stability stable
     */
    readonly email?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dns_zone_v2.html#name DataOpentelekomcloudDnsZoneV2#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dns_zone_v2.html#status DataOpentelekomcloudDnsZoneV2#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dns_zone_v2.html#tags DataOpentelekomcloudDnsZoneV2#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dns_zone_v2.html#ttl DataOpentelekomcloudDnsZoneV2#ttl}.
     *
     * @stability stable
     */
    readonly ttl?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dns_zone_v2.html#zone_type DataOpentelekomcloudDnsZoneV2#zone_type}.
     *
     * @stability stable
     */
    readonly zoneType?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dns_zone_v2.html opentelekomcloud_dns_zone_v2}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudDnsZoneV2 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/dns_zone_v2.html opentelekomcloud_dns_zone_v2} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudDnsZoneV2Config);
    /**
     * @stability stable
     */
    get createdAt(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _email?;
    /**
     * @stability stable
     */
    get email(): string | undefined;
    /**
     * @stability stable
     */
    set email(value: string | undefined);
    /**
     * @stability stable
     */
    resetEmail(): void;
    /**
     * @stability stable
     */
    get emailInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    links(key: string): string;
    /**
     * @stability stable
     */
    get masters(): string[];
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get poolId(): string;
    /**
     * @stability stable
     */
    get projectId(): string;
    /**
     * @stability stable
     */
    get serial(): number;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string | undefined;
    /**
     * @stability stable
     */
    set status(value: string | undefined);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _ttl?;
    /**
     * @stability stable
     */
    get ttl(): number | undefined;
    /**
     * @stability stable
     */
    set ttl(value: number | undefined);
    /**
     * @stability stable
     */
    resetTtl(): void;
    /**
     * @stability stable
     */
    get ttlInput(): number | undefined;
    /**
     * @stability stable
     */
    get updatedAt(): string;
    private _zoneType?;
    /**
     * @stability stable
     */
    get zoneType(): string | undefined;
    /**
     * @stability stable
     */
    set zoneType(value: string | undefined);
    /**
     * @stability stable
     */
    resetZoneType(): void;
    /**
     * @stability stable
     */
    get zoneTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
