import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudIdentityAuthScopeV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_auth_scope_v3.html#name DataOpentelekomcloudIdentityAuthScopeV3#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_auth_scope_v3.html#region DataOpentelekomcloudIdentityAuthScopeV3#region}.
     *
     * @stability stable
     */
    readonly region?: string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudIdentityAuthScopeV3Roles extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get roleId(): string;
    /**
     * @stability stable
     */
    get roleName(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_auth_scope_v3.html opentelekomcloud_identity_auth_scope_v3}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudIdentityAuthScopeV3 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_auth_scope_v3.html opentelekomcloud_identity_auth_scope_v3} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOpentelekomcloudIdentityAuthScopeV3Config);
    /**
     * @stability stable
     */
    get domainId(): string;
    /**
     * @stability stable
     */
    get domainName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get projectDomainId(): string;
    /**
     * @stability stable
     */
    get projectDomainName(): string;
    /**
     * @stability stable
     */
    get projectId(): string;
    /**
     * @stability stable
     */
    get projectName(): string;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    roles(index: string): DataOpentelekomcloudIdentityAuthScopeV3Roles;
    /**
     * @stability stable
     */
    get userDomainId(): string;
    /**
     * @stability stable
     */
    get userDomainName(): string;
    /**
     * @stability stable
     */
    get userId(): string;
    /**
     * @stability stable
     */
    get userName(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
