import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudIdentityCredentialV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_credential_v3.html#user_id DataOpentelekomcloudIdentityCredentialV3#user_id}.
     *
     * @stability stable
     */
    readonly userId?: string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudIdentityCredentialV3Credentials extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get access(): string;
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get userId(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_credential_v3.html opentelekomcloud_identity_credential_v3}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudIdentityCredentialV3 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_credential_v3.html opentelekomcloud_identity_credential_v3} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudIdentityCredentialV3Config);
    /**
     * @stability stable
     */
    credentials(index: string): DataOpentelekomcloudIdentityCredentialV3Credentials;
    /**
     * @stability stable
     */
    get id(): string;
    private _userId?;
    /**
     * @stability stable
     */
    get userId(): string | undefined;
    /**
     * @stability stable
     */
    set userId(value: string | undefined);
    /**
     * @stability stable
     */
    resetUserId(): void;
    /**
     * @stability stable
     */
    get userIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
