import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudIdentityProjectV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_project_v3.html#domain_id DataOpentelekomcloudIdentityProjectV3#domain_id}.
     *
     * @stability stable
     */
    readonly domainId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_project_v3.html#enabled DataOpentelekomcloudIdentityProjectV3#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_project_v3.html#is_domain DataOpentelekomcloudIdentityProjectV3#is_domain}.
     *
     * @stability stable
     */
    readonly isDomain?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_project_v3.html#name DataOpentelekomcloudIdentityProjectV3#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_project_v3.html#parent_id DataOpentelekomcloudIdentityProjectV3#parent_id}.
     *
     * @stability stable
     */
    readonly parentId?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_project_v3.html opentelekomcloud_identity_project_v3}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudIdentityProjectV3 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/identity_project_v3.html opentelekomcloud_identity_project_v3} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudIdentityProjectV3Config);
    /**
     * @stability stable
     */
    get description(): string;
    private _domainId?;
    /**
     * @stability stable
     */
    get domainId(): string | undefined;
    /**
     * @stability stable
     */
    set domainId(value: string | undefined);
    /**
     * @stability stable
     */
    resetDomainId(): void;
    /**
     * @stability stable
     */
    get domainIdInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _isDomain?;
    /**
     * @stability stable
     */
    get isDomain(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isDomain(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsDomain(): void;
    /**
     * @stability stable
     */
    get isDomainInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _parentId?;
    /**
     * @stability stable
     */
    get parentId(): string | undefined;
    /**
     * @stability stable
     */
    set parentId(value: string | undefined);
    /**
     * @stability stable
     */
    resetParentId(): void;
    /**
     * @stability stable
     */
    get parentIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
