import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudImagesImageV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/images_image_v2.html#most_recent DataOpentelekomcloudImagesImageV2#most_recent}.
     *
     * @stability stable
     */
    readonly mostRecent?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/images_image_v2.html#name DataOpentelekomcloudImagesImageV2#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/images_image_v2.html#name_regex DataOpentelekomcloudImagesImageV2#name_regex}.
     *
     * @stability stable
     */
    readonly nameRegex?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/images_image_v2.html#owner DataOpentelekomcloudImagesImageV2#owner}.
     *
     * @stability stable
     */
    readonly owner?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/images_image_v2.html#properties DataOpentelekomcloudImagesImageV2#properties}.
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/images_image_v2.html#region DataOpentelekomcloudImagesImageV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/images_image_v2.html#size_max DataOpentelekomcloudImagesImageV2#size_max}.
     *
     * @stability stable
     */
    readonly sizeMax?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/images_image_v2.html#size_min DataOpentelekomcloudImagesImageV2#size_min}.
     *
     * @stability stable
     */
    readonly sizeMin?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/images_image_v2.html#sort_direction DataOpentelekomcloudImagesImageV2#sort_direction}.
     *
     * @stability stable
     */
    readonly sortDirection?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/images_image_v2.html#sort_key DataOpentelekomcloudImagesImageV2#sort_key}.
     *
     * @stability stable
     */
    readonly sortKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/images_image_v2.html#tag DataOpentelekomcloudImagesImageV2#tag}.
     *
     * @stability stable
     */
    readonly tag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/images_image_v2.html#visibility DataOpentelekomcloudImagesImageV2#visibility}.
     *
     * @stability stable
     */
    readonly visibility?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/images_image_v2.html opentelekomcloud_images_image_v2}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudImagesImageV2 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/images_image_v2.html opentelekomcloud_images_image_v2} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudImagesImageV2Config);
    /**
     * @stability stable
     */
    get checksum(): string;
    /**
     * @stability stable
     */
    get containerFormat(): string;
    /**
     * @stability stable
     */
    get createdAt(): string;
    /**
     * @stability stable
     */
    get diskFormat(): string;
    /**
     * @stability stable
     */
    get file(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    metadata(key: string): string;
    /**
     * @stability stable
     */
    get minDiskGb(): number;
    /**
     * @stability stable
     */
    get minRamMb(): number;
    private _mostRecent?;
    /**
     * @stability stable
     */
    get mostRecent(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set mostRecent(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetMostRecent(): void;
    /**
     * @stability stable
     */
    get mostRecentInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nameRegex?;
    /**
     * @stability stable
     */
    get nameRegex(): string | undefined;
    /**
     * @stability stable
     */
    set nameRegex(value: string | undefined);
    /**
     * @stability stable
     */
    resetNameRegex(): void;
    /**
     * @stability stable
     */
    get nameRegexInput(): string | undefined;
    private _owner?;
    /**
     * @stability stable
     */
    get owner(): string | undefined;
    /**
     * @stability stable
     */
    set owner(value: string | undefined);
    /**
     * @stability stable
     */
    resetOwner(): void;
    /**
     * @stability stable
     */
    get ownerInput(): string | undefined;
    private _properties?;
    /**
     * @stability stable
     */
    get properties(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set properties(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetProperties(): void;
    /**
     * @stability stable
     */
    get propertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get protected(): any;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    get sizeBytes(): number;
    private _sizeMax?;
    /**
     * @stability stable
     */
    get sizeMax(): number | undefined;
    /**
     * @stability stable
     */
    set sizeMax(value: number | undefined);
    /**
     * @stability stable
     */
    resetSizeMax(): void;
    /**
     * @stability stable
     */
    get sizeMaxInput(): number | undefined;
    private _sizeMin?;
    /**
     * @stability stable
     */
    get sizeMin(): number | undefined;
    /**
     * @stability stable
     */
    set sizeMin(value: number | undefined);
    /**
     * @stability stable
     */
    resetSizeMin(): void;
    /**
     * @stability stable
     */
    get sizeMinInput(): number | undefined;
    private _sortDirection?;
    /**
     * @stability stable
     */
    get sortDirection(): string | undefined;
    /**
     * @stability stable
     */
    set sortDirection(value: string | undefined);
    /**
     * @stability stable
     */
    resetSortDirection(): void;
    /**
     * @stability stable
     */
    get sortDirectionInput(): string | undefined;
    private _sortKey?;
    /**
     * @stability stable
     */
    get sortKey(): string | undefined;
    /**
     * @stability stable
     */
    set sortKey(value: string | undefined);
    /**
     * @stability stable
     */
    resetSortKey(): void;
    /**
     * @stability stable
     */
    get sortKeyInput(): string | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): string | undefined;
    /**
     * @stability stable
     */
    set tag(value: string | undefined);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): string | undefined;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    get updatedAt(): string;
    private _visibility?;
    /**
     * @stability stable
     */
    get visibility(): string | undefined;
    /**
     * @stability stable
     */
    set visibility(value: string | undefined);
    /**
     * @stability stable
     */
    resetVisibility(): void;
    /**
     * @stability stable
     */
    get visibilityInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
