import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudKmsDataKeyV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_data_key_v1.html#datakey_length DataOpentelekomcloudKmsDataKeyV1#datakey_length}.
     *
     * @stability stable
     */
    readonly datakeyLength: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_data_key_v1.html#encryption_context DataOpentelekomcloudKmsDataKeyV1#encryption_context}.
     *
     * @stability stable
     */
    readonly encryptionContext?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_data_key_v1.html#key_id DataOpentelekomcloudKmsDataKeyV1#key_id}.
     *
     * @stability stable
     */
    readonly keyId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_data_key_v1.html opentelekomcloud_kms_data_key_v1}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudKmsDataKeyV1 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_data_key_v1.html opentelekomcloud_kms_data_key_v1} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOpentelekomcloudKmsDataKeyV1Config);
    /**
     * @stability stable
     */
    get cipherText(): string;
    private _datakeyLength?;
    /**
     * @stability stable
     */
    get datakeyLength(): string;
    /**
     * @stability stable
     */
    set datakeyLength(value: string);
    /**
     * @stability stable
     */
    get datakeyLengthInput(): string | undefined;
    private _encryptionContext?;
    /**
     * @stability stable
     */
    get encryptionContext(): string | undefined;
    /**
     * @stability stable
     */
    set encryptionContext(value: string | undefined);
    /**
     * @stability stable
     */
    resetEncryptionContext(): void;
    /**
     * @stability stable
     */
    get encryptionContextInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _keyId?;
    /**
     * @stability stable
     */
    get keyId(): string;
    /**
     * @stability stable
     */
    set keyId(value: string);
    /**
     * @stability stable
     */
    get keyIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get plainText(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
