import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudKmsKeyV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_key_v1.html#default_key_flag DataOpentelekomcloudKmsKeyV1#default_key_flag}.
     *
     * @stability stable
     */
    readonly defaultKeyFlag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_key_v1.html#domain_id DataOpentelekomcloudKmsKeyV1#domain_id}.
     *
     * @stability stable
     */
    readonly domainId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_key_v1.html#key_alias DataOpentelekomcloudKmsKeyV1#key_alias}.
     *
     * @stability stable
     */
    readonly keyAlias?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_key_v1.html#key_description DataOpentelekomcloudKmsKeyV1#key_description}.
     *
     * @stability stable
     */
    readonly keyDescription?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_key_v1.html#key_id DataOpentelekomcloudKmsKeyV1#key_id}.
     *
     * @stability stable
     */
    readonly keyId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_key_v1.html#key_state DataOpentelekomcloudKmsKeyV1#key_state}.
     *
     * @stability stable
     */
    readonly keyState?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_key_v1.html#origin DataOpentelekomcloudKmsKeyV1#origin}.
     *
     * @stability stable
     */
    readonly origin?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_key_v1.html#realm DataOpentelekomcloudKmsKeyV1#realm}.
     *
     * @stability stable
     */
    readonly realm?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_key_v1.html opentelekomcloud_kms_key_v1}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudKmsKeyV1 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/kms_key_v1.html opentelekomcloud_kms_key_v1} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudKmsKeyV1Config);
    /**
     * @stability stable
     */
    get creationDate(): string;
    private _defaultKeyFlag?;
    /**
     * @stability stable
     */
    get defaultKeyFlag(): string | undefined;
    /**
     * @stability stable
     */
    set defaultKeyFlag(value: string | undefined);
    /**
     * @stability stable
     */
    resetDefaultKeyFlag(): void;
    /**
     * @stability stable
     */
    get defaultKeyFlagInput(): string | undefined;
    private _domainId?;
    /**
     * @stability stable
     */
    get domainId(): string | undefined;
    /**
     * @stability stable
     */
    set domainId(value: string | undefined);
    /**
     * @stability stable
     */
    resetDomainId(): void;
    /**
     * @stability stable
     */
    get domainIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get expirationTime(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _keyAlias?;
    /**
     * @stability stable
     */
    get keyAlias(): string | undefined;
    /**
     * @stability stable
     */
    set keyAlias(value: string | undefined);
    /**
     * @stability stable
     */
    resetKeyAlias(): void;
    /**
     * @stability stable
     */
    get keyAliasInput(): string | undefined;
    private _keyDescription?;
    /**
     * @stability stable
     */
    get keyDescription(): string | undefined;
    /**
     * @stability stable
     */
    set keyDescription(value: string | undefined);
    /**
     * @stability stable
     */
    resetKeyDescription(): void;
    /**
     * @stability stable
     */
    get keyDescriptionInput(): string | undefined;
    private _keyId?;
    /**
     * @stability stable
     */
    get keyId(): string | undefined;
    /**
     * @stability stable
     */
    set keyId(value: string | undefined);
    /**
     * @stability stable
     */
    resetKeyId(): void;
    /**
     * @stability stable
     */
    get keyIdInput(): string | undefined;
    private _keyState?;
    /**
     * @stability stable
     */
    get keyState(): string | undefined;
    /**
     * @stability stable
     */
    set keyState(value: string | undefined);
    /**
     * @stability stable
     */
    resetKeyState(): void;
    /**
     * @stability stable
     */
    get keyStateInput(): string | undefined;
    private _origin?;
    /**
     * @stability stable
     */
    get origin(): string | undefined;
    /**
     * @stability stable
     */
    set origin(value: string | undefined);
    /**
     * @stability stable
     */
    resetOrigin(): void;
    /**
     * @stability stable
     */
    get originInput(): string | undefined;
    private _realm?;
    /**
     * @stability stable
     */
    get realm(): string | undefined;
    /**
     * @stability stable
     */
    set realm(value: string | undefined);
    /**
     * @stability stable
     */
    resetRealm(): void;
    /**
     * @stability stable
     */
    get realmInput(): string | undefined;
    /**
     * @stability stable
     */
    get scheduledDeletionDate(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
