import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudLbCertificateV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_certificate_v3.html#domain DataOpentelekomcloudLbCertificateV3#domain}.
     *
     * @stability stable
     */
    readonly domain?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_certificate_v3.html#name DataOpentelekomcloudLbCertificateV3#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_certificate_v3.html#type DataOpentelekomcloudLbCertificateV3#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_certificate_v3.html opentelekomcloud_lb_certificate_v3}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudLbCertificateV3 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_certificate_v3.html opentelekomcloud_lb_certificate_v3} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudLbCertificateV3Config);
    /**
     * @stability stable
     */
    get certificate(): string;
    /**
     * @stability stable
     */
    get createdAt(): string;
    /**
     * @stability stable
     */
    get description(): string;
    private _domain?;
    /**
     * @stability stable
     */
    get domain(): string | undefined;
    /**
     * @stability stable
     */
    set domain(value: string | undefined);
    /**
     * @stability stable
     */
    resetDomain(): void;
    /**
     * @stability stable
     */
    get domainInput(): string | undefined;
    /**
     * @stability stable
     */
    get expireTime(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get privateKey(): string;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string | undefined;
    /**
     * @stability stable
     */
    set type(value: string | undefined);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    /**
     * @stability stable
     */
    get updatedAt(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
