import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudLbLoadbalancerV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_loadbalancer_v3.html#l4_flavor DataOpentelekomcloudLbLoadbalancerV3#l4_flavor}.
     *
     * @stability stable
     */
    readonly l4Flavor?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_loadbalancer_v3.html#l7_flavor DataOpentelekomcloudLbLoadbalancerV3#l7_flavor}.
     *
     * @stability stable
     */
    readonly l7Flavor?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_loadbalancer_v3.html#name DataOpentelekomcloudLbLoadbalancerV3#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_loadbalancer_v3.html#router_id DataOpentelekomcloudLbLoadbalancerV3#router_id}.
     *
     * @stability stable
     */
    readonly routerId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_loadbalancer_v3.html#subnet_id DataOpentelekomcloudLbLoadbalancerV3#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_loadbalancer_v3.html#vip_address DataOpentelekomcloudLbLoadbalancerV3#vip_address}.
     *
     * @stability stable
     */
    readonly vipAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_loadbalancer_v3.html#vip_port_id DataOpentelekomcloudLbLoadbalancerV3#vip_port_id}.
     *
     * @stability stable
     */
    readonly vipPortId?: string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudLbLoadbalancerV3PublicIp extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get address(): string;
    /**
     * @stability stable
     */
    get bandwidthChargeMode(): string;
    /**
     * @stability stable
     */
    get bandwidthName(): string;
    /**
     * @stability stable
     */
    get bandwidthShareType(): string;
    /**
     * @stability stable
     */
    get bandwidthSize(): number;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get ipType(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_loadbalancer_v3.html opentelekomcloud_lb_loadbalancer_v3}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudLbLoadbalancerV3 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/lb_loadbalancer_v3.html opentelekomcloud_lb_loadbalancer_v3} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudLbLoadbalancerV3Config);
    /**
     * @stability stable
     */
    get adminStateUp(): any;
    /**
     * @stability stable
     */
    get availabilityZones(): string[];
    /**
     * @stability stable
     */
    get createdAt(): string;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get ipTargetEnable(): any;
    private _l4Flavor?;
    /**
     * @stability stable
     */
    get l4Flavor(): string | undefined;
    /**
     * @stability stable
     */
    set l4Flavor(value: string | undefined);
    /**
     * @stability stable
     */
    resetL4Flavor(): void;
    /**
     * @stability stable
     */
    get l4FlavorInput(): string | undefined;
    private _l7Flavor?;
    /**
     * @stability stable
     */
    get l7Flavor(): string | undefined;
    /**
     * @stability stable
     */
    set l7Flavor(value: string | undefined);
    /**
     * @stability stable
     */
    resetL7Flavor(): void;
    /**
     * @stability stable
     */
    get l7FlavorInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get networkIds(): string[];
    /**
     * @stability stable
     */
    publicIp(index: string): DataOpentelekomcloudLbLoadbalancerV3PublicIp;
    private _routerId?;
    /**
     * @stability stable
     */
    get routerId(): string | undefined;
    /**
     * @stability stable
     */
    set routerId(value: string | undefined);
    /**
     * @stability stable
     */
    resetRouterId(): void;
    /**
     * @stability stable
     */
    get routerIdInput(): string | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string | undefined;
    /**
     * @stability stable
     */
    set subnetId(value: string | undefined);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get updatedAt(): string;
    private _vipAddress?;
    /**
     * @stability stable
     */
    get vipAddress(): string | undefined;
    /**
     * @stability stable
     */
    set vipAddress(value: string | undefined);
    /**
     * @stability stable
     */
    resetVipAddress(): void;
    /**
     * @stability stable
     */
    get vipAddressInput(): string | undefined;
    private _vipPortId?;
    /**
     * @stability stable
     */
    get vipPortId(): string | undefined;
    /**
     * @stability stable
     */
    set vipPortId(value: string | undefined);
    /**
     * @stability stable
     */
    resetVipPortId(): void;
    /**
     * @stability stable
     */
    get vipPortIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
